package cn.com.wawa.service.api.enums;
public enum CenterMsgStatusType {
    UN_SEND(1, "未发送"),
    WAIT_SENT(2, "待发送"),
    SENDED(3, "已发送"),
    DELETE(4, "已删除");

    private int code;

    private String desc;

    CenterMsgStatusType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CenterMsgStatusType getCenterMsgStatus(int code) {
        for (CenterMsgStatusType e : CenterMsgStatusType.values()) {
            if (e.code == code) {
                return e;
            }
        }
        return null;
    }

    public static String getCenterMsgStatusDescr(int code) {
        for (CenterMsgStatusType e : CenterMsgStatusType.values()) {
            if (e.code == code) {
                return e.desc;
            }
        }
        return "";
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
