package cn.com.wawa.service.api.enums;

import org.apache.commons.lang.StringUtils;

public enum KuaiDi100LogisticsEnum {
    BAI_SHI_HUI_TONG(1, "baishiwuliu","百世"),
    ZHONG_TONG(2, "zhongtong","中通");

    private int value;
    private String desc;
    private String msg;

    KuaiDi100LogisticsEnum(int value, String desc,String msg) {
        this.value = value;
        this.desc = desc;
        this.msg = msg;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public String msg() {
        return msg;
    }

    public static KuaiDi100LogisticsEnum get(int value) {
        for (KuaiDi100LogisticsEnum item : KuaiDi100LogisticsEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }

    /**
     * 默认百世快递
     * @param msg
     * @return
     */
    public static KuaiDi100LogisticsEnum getByMsgIndex(String msg) {
        if (StringUtils.isBlank(msg)){
            return BAI_SHI_HUI_TONG;
        }
        for (KuaiDi100LogisticsEnum item : KuaiDi100LogisticsEnum.values()) {
            if (msg.indexOf(item.msg()) >= 0) {
                return item;
            }
        }
        return BAI_SHI_HUI_TONG;
    }

}
