package cn.com.wawa.service.api.enums;

public enum PushStatus {
    UN_SEND(1, "未发送"),
    WAIT_SENT(2, "待发送"),
    SENDED(3, "已发送"),
    DELETE(4, "已删除");

    private int code;

    private String desc;

    PushStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PushStatus getPushStatus(int code) {
        for (PushStatus e : PushStatus.values()) {
            if (e.code == code) {
                return e;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
