package cn.com.wawa.service.api.enums;

/**
 * Created by danke on 2018/1/31.
 * 用户渠道来源枚举
 */
public enum UserChannelEnum {

    APP_USER(0,"app用户"),
    H5_USER(1,"h5用户");

    private int code;
    private String msg;

    UserChannelEnum(int code,String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static UserChannelEnum get(int code) {
        for (UserChannelEnum item : UserChannelEnum.values()) {
            if (item.getCode() == code) {
                return item;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
