package cn.com.wawa.service.api.enums;

public enum UserClientTypeEnum {
    UN_KNOWN(0, "未知"),
    IOS(1, "IOS"),
    ANDROID(2, "安卓"),
    H5(3,"H5");

    private int    value;
    private String desc;

    UserClientTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public boolean isAppClient(){
        return UserClientTypeEnum.ANDROID.equals(this) || UserClientTypeEnum.IOS.equals(this);
    }

    public static UserClientTypeEnum get(int value) {
        for (UserClientTypeEnum item : UserClientTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }

    public static UserClientTypeEnum get(boolean isIOS,boolean isAndroid) {
        if(isIOS){
            return IOS;
        }
        if(isAndroid){
            return ANDROID;
        }
        return UN_KNOWN;
    }
}
