package cn.com.wawa.service.api.enums;

/**
 * 娃娃机的玩法
 */
public enum WawaCatcherPlayTypeEnum {

    CLASSIC(1, "经典玩法"),
    TIME_LIMIT(2, "限时玩法"),
    NO_BOARD(3,"无挡板玩法"),
    PLUG_LEAK(4, "捡漏玩法"),
    BATTLE(5, "匹配玩法");


    private int    value;
    private String desc;

    WawaCatcherPlayTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static WawaCatcherPlayTypeEnum get(int value) {
        for (WawaCatcherPlayTypeEnum item : WawaCatcherPlayTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return WawaCatcherPlayTypeEnum.CLASSIC;//默认经典玩法
    }
}
