package cn.com.wawa.service.api.enums;

/**
 * Created by danke on 2018/4/10.
 * 订单类型枚举
 */
public enum WinOrderTypeEnum {

    GENERAL_ORDER(0,"普通订单"),
    COMPENSATE_ORDER(1,"包赔订单"),
    APPEAL_ORDER(2,"申诉订单"),
    TICKET_ORDER(3,"兑换券订单"),
    HELP_CATCHED(4, "帮抓抓中订单"),
    SHARER_REWARD(5, "分享达人奖励");

    private int code;
    private String msg;

    WinOrderTypeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static WinOrderTypeEnum get(int value) {
        for (WinOrderTypeEnum item : WinOrderTypeEnum.values()) {
            if (item.getCode() == value) {
                return item;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

}
