package cn.com.wawa.service.api.enums.bigpop;

/**
 * 首页大弹窗种类
 */
public enum HomePopsEnum {
    VERSION_UPDATE_POP(1, "版本更新弹窗"),
    RED_PACKAGE_POP(2, "450币红包弹窗"),
    FIRST_CHARGE_POP(3, "首冲签到礼包弹窗"),
    PUSH_PERMISSION_POP(4, "推送权限获取弹窗"),
    BIG_POP(5, "运营大弹窗"),
    FLIP_CARD_POP(6, "翻翻卡弹窗"),
    FRESHMAN_SIGN(7, "新人签到礼包弹窗"),
    INVITE_PACKAGE(8, "邀请礼包弹窗");

    private int value;
    private String desc;

    HomePopsEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static HomePopsEnum get(int value) {
        for (HomePopsEnum item : HomePopsEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }

}
