package cn.com.wawa.service.api.enums.groupbook;

/**
 * Created by danke on 2018/3/1.
 */
public enum OpenGroupBookStatusEnum {

    OPEN_WAIT(0,"已申请待支付"),
    OPEN_ING(1,"进行中"),
    OPEN_SUCCESS(2,"开团成功"),
    OPEN_FAIL(3,"开团失败");

    private int code;

    private String msg;

    OpenGroupBookStatusEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static OpenGroupBookStatusEnum get(int value) {
        for (OpenGroupBookStatusEnum item : OpenGroupBookStatusEnum.values()) {
            if (item.code == value) {
                return item;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }


    public String getMsg() {
        return msg;
    }

}
