package cn.com.wawa.service.api.enums.strategy;

/**
 * Created by danke on 2018/7/19.
 * 资源属性获取枚举,key用于获取自定义执行action
 */
public enum ResourceStrategyFieldEnum {

    USER_NOT_CHARGE_DAY(1,"用户生命周期未充值天数");

    //code之后作为判断数据类型的值,提供前段渲染做判断
    private int code;
    private String msg;

    /**
     * @param code
     * @return
     */
    public static ResourceStrategyFieldEnum fromStatus(Integer code) {
        if (code==null) {
            return null;
        }
        for (ResourceStrategyFieldEnum resourceStrategyFieldEnum : ResourceStrategyFieldEnum.values()) {
            if (resourceStrategyFieldEnum.getCode() == code) {
                return resourceStrategyFieldEnum;
            }
        }
        return null;
    }

    ResourceStrategyFieldEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
