package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.user.UserCoinRecordDto;
import cn.com.wawa.service.api.dto.user.UserDetailDto;
import cn.com.wawa.service.api.dto.user.UserDto;
import cn.com.wawa.service.api.query.UserManagerQuery;

import java.util.List;

/**
 * Created by danke on 2017/12/13.
 */
@AdvancedFeignClient
public interface RemoteUserManagerService {
    /**
     * 通过用户id查询用户基本信息
     */
    PagerResponse<UserDto> findUserByQuery(UserManagerQuery query, PagerRequest pagerRequest);

    /**
     * 通过用户id查询用户详情(包括基本信息,地址,抓取娃娃信息,抓抓币信息)
     */
    UserDetailDto queryUserDetailById(Long userId);

    /**
     * 通过用户id查询用户金币变更记录
     */
    List<UserCoinRecordDto> queryUserCoinRecord(String startTime, String endTime, Long userId, PagerRequest pagerRequest);
    
    /**
     * 重置用户信息（仅限测试账号）
     *
     * @author zhanglihui
     * @param userId
     */
    boolean reset(Long userId);

    /**
     * 通过用户id批量查询用户
     */
    List<UserDto> findByUserIds(List<Long> userIds);

    /**
     * 统计用户在某时间段内的抓抓币记录数量
     * @param startTime
     * @param endTime
     * @param userId
     * @return
     */
    int countUserCoinRecordByQuery(String startTime, String endTime, Long userId);

    /**
     * 批量更新
     */
    int batchUpdateTestUser(List<Long> userIds);

    List<Long> findUserIdsByQuery(UserManagerQuery query,PagerRequest pagerRequest);
}
