package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.WawaCatcherDto;
import cn.com.wawa.service.api.dto.WawaCatcherSaveDto;
import cn.com.wawa.service.api.dto.WawaCatcherSimpleDto;
import cn.com.wawa.service.api.enums.WawaCatcherOperateEnum;
import cn.com.wawa.service.api.query.WawaCatcherQuery;

import java.util.List;

/**
 * Created by gyf .
 * 2017/10/27 .
 */
@AdvancedFeignClient
public interface RemoteWawaCatcherService {

    /**
     * 分页
     * @param pagerRequest
     * @return
     */
    PagerResponse<WawaCatcherDto> page(PagerRequest pagerRequest);

    PagerResponse<WawaCatcherDto> pageWithQuery(PagerRequest pagerRequest, String query, Integer status, String wawaName,Integer playType);

    /**
     * 更新权重
     * @param catcherId
     * @param payload
     * @return
     */
    Boolean updatePayload(Long catcherId, Long payload);

    /**
     * 删除娃娃机
     * @param catcherId
     * @return
     */
    Boolean delete(Long catcherId);

    /**
     * 更新状态
     * @param catcherId
     * @param operate
     * @return
     */
    Boolean updateStatus(Long catcherId, WawaCatcherOperateEnum operate);

    /**
     * 保存,带id就是更新,不带id就是插入
     * @param catcher
     * @return
     */
    Boolean save(WawaCatcherSaveDto catcher);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    WawaCatcherSimpleDto find(Long id);

    Boolean updateRemark( Long catcherId, String remark);

    int countByStatus( Long catcherStatus,  Long wawaId);

    /**
     * 条件查询,根据库存数量倒序
     */
    PagerResponse<WawaCatcherDto>  findCatcherDescByStock(PagerRequest pagerRequest, WawaCatcherQuery query);

    /**
     * 条件查询娃娃机
     */
    List<WawaCatcherDto> findCatcherByQuery(WawaCatcherQuery query);

    /**
     * 更新娃娃机
     */
    Boolean update(WawaCatcherDto wawaCatcherDto);
    /**
     * 通过条件,查询所有娃娃机
     */
    PagerResponse<WawaCatcherDto>  findAllCatcherByPage(PagerRequest pagerRequest, WawaCatcherQuery query);

    /**
     * 控制是否显示系统维护中
     * @param status
     * @return
     */
    Boolean controlCatcher(Integer status);

}
