package cn.com.wawa.service.api.bean;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 功能描述:controller返回数据总格式
 */
@ApiModel("返回json数据")
public class JsonResult<T>{
    @ApiModelProperty("请求状态")
    private boolean success;
    @ApiModelProperty("请求错误消息")
    private String message;
    @ApiModelProperty("请求数据体")
    private T data;
    @ApiModelProperty("code")
    private int code;

	/**
     * successResult
     * @param data
     * @param <T>
     * @return
     */
    public static <T> JsonResult<T> successResult(T data) {
        JsonResult<T> jsonResult = new JsonResult<>();
        jsonResult.setSuccess(true);
        jsonResult.setData(data);
        return jsonResult;
    }

	/**
     * failedResult
     * @param message
     * @param <T>
     * @return
     */
    public static <T> JsonResult<T> failedResult(String message) {
        JsonResult<T> jsonResult = new JsonResult<>();
        jsonResult.setSuccess(false);
        jsonResult.setMessage(message);
        jsonResult.setData(null);
        return jsonResult;
    }

    /**
     * 返回code
     * @param code
     * @param <T>
     * @return
     */
    public static <T> JsonResult<T> failedResult(int code) {
        JsonResult<T> jsonResult = new JsonResult<>();
        jsonResult.setSuccess(false);
        jsonResult.setMessage(null);
        jsonResult.setCode(code);
        jsonResult.setData(null);
        return jsonResult;
    }

    /**
     * fanhui code + message
     * @param code
     * @param message
     * @param <T>
     * @return
     */
    public static <T> JsonResult<T> failedResult(int code, String message) {
        JsonResult<T> jsonResult = new JsonResult<>();
        jsonResult.setSuccess(false);
        jsonResult.setMessage(message);
        jsonResult.setData(null);
        jsonResult.setCode(code);
        return jsonResult;
    }

    /**
     * failedData
     * @param data
     * @param <T>
     * @return
     */
    public static <T> JsonResult<T> failedData(T data) {
        JsonResult<T> jsonResult = new JsonResult<>();
        jsonResult.setSuccess(false);
        jsonResult.setMessage("");
        jsonResult.setData(data);
        return jsonResult;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}
