package cn.com.wawa.service.api.enums;

/**
 * 用户账户变动明细类型
 */
public enum AccountChangeTypeEnum {

    CHARGE(1, "充值"),
    FIRST_CHARGE(2, "首冲奖励"),
    CATCH_WAWA(3, "抽娃娃消费"),
    POSTAGE(4, "邮费");

    private int    value;
    private String desc;

    AccountChangeTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static AccountChangeTypeEnum get(int value) {
        for (AccountChangeTypeEnum item : AccountChangeTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
