package cn.com.wawa.service.api.enums;

public enum ErrorCodeEnum {

    E100000(100000,"未定义错误"),
    E100001(100001, "未登录"),
    E999999(999999, "系统错误"),

    E100100(100100, "娃娃机维护"),
    E100101(100101, "娃娃机被占用"),
    E100102(100102, "娃娃机被占用(未抢占到)"),
    E100103(100103, "用户抓抓币不足"),
    E100104(100104, "通知接收到的订单,不是该用户的订单");
    private int code;

    private String desc;

    private ErrorCodeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * code.
     *
     * @return the code
     */
    public int getCode() {
        return code;
    }

    /**
     * desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }
}
