/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.common.tool;

import cn.com.duiba.wolf.utils.NumberUtils;
import com.tls.base64_url.base64_url;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.Arrays;
import org.json.JSONObject;

public class TlsSigature {
    private static String authKey;
    private static String appId;
    private static String privateKey;

    public static String getSig(String userId) throws Exception {
        String privStr = privateKey;
        GenTLSSignatureResult result = TlsSigature.GenTLSSignatureEx(NumberUtils.parseInt((String)appId, (int)0), String.valueOf(userId), privStr);
        if (0 == result.urlSig.length()) {
            System.out.println("GenTLSSignatureEx failed: " + result.errMessage);
            throw new RuntimeException();
        }
        String sig = result.urlSig;
        return sig;
    }

    @Deprecated
    public static GenTLSSignatureResult GenTLSSignature(long expire, String strAppid3rd, long skdAppid, String identifier, long accountType, String privStr) throws IOException {
        GenTLSSignatureResult result = new GenTLSSignatureResult();
        Security.addProvider((Provider)new BouncyCastleProvider());
        CharArrayReader reader = new CharArrayReader(privStr.toCharArray());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        PEMParser parser = new PEMParser((Reader)reader);
        Object obj = parser.readObject();
        parser.close();
        PrivateKey privKeyStruct = converter.getPrivateKey((PrivateKeyInfo)obj);
        String jsonString = "{\"TLS.account_type\":\"" + accountType + "\",\"TLS.identifier\":\"" + identifier + "\",\"TLS.appid_at_3rd\":\"" + strAppid3rd + "\",\"TLS.sdk_appid\":\"" + skdAppid + "\",\"TLS.expire_after\":\"" + expire + "\"}";
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String SerialString = "TLS.appid_at_3rd:" + strAppid3rd + "\nTLS.account_type:" + accountType + "\nTLS.identifier:" + identifier + "\nTLS.sdk_appid:" + skdAppid + "\nTLS.time:" + time + "\nTLS.expire_after:" + expire + "\n";
        try {
            String userSig;
            Signature signature = Signature.getInstance("SHA256withECDSA", "BC");
            signature.initSign(privKeyStruct);
            signature.update(SerialString.getBytes(Charset.forName("UTF-8")));
            byte[] signatureBytes = signature.sign();
            String sigTLS = Base64.encodeBase64String((byte[])signatureBytes);
            JSONObject jsonObject = new JSONObject(jsonString);
            jsonObject.put("TLS.sig", (Object)sigTLS);
            jsonObject.put("TLS.time", (Object)time);
            jsonString = jsonObject.toString();
            Deflater compresser = new Deflater();
            compresser.setInput(jsonString.getBytes(Charset.forName("UTF-8")));
            compresser.finish();
            byte[] compressBytes = new byte[512];
            int compressBytesLength = compresser.deflate(compressBytes);
            compresser.end();
            result.urlSig = userSig = new String(base64_url.base64EncodeUrl((byte[])Arrays.copyOfRange((byte[])compressBytes, (int)0, (int)compressBytesLength)));
        }
        catch (Exception e) {
            e.printStackTrace();
            result.errMessage = "generate usersig failed";
        }
        return result;
    }

    @Deprecated
    public static CheckTLSSignatureResult CheckTLSSignature(String urlSig, String strAppid3rd, long skdAppid, String identifier, long accountType, String publicKey) throws DataFormatException {
        CheckTLSSignatureResult result = new CheckTLSSignatureResult();
        Security.addProvider((Provider)new BouncyCastleProvider());
        Base64 decoder = new Base64();
        byte[] compressBytes = base64_url.base64DecodeUrl((byte[])urlSig.getBytes(Charset.forName("UTF-8")));
        Inflater decompression = new Inflater();
        decompression.setInput(compressBytes, 0, compressBytes.length);
        byte[] decompressBytes = new byte[1024];
        int decompressLength = decompression.inflate(decompressBytes);
        decompression.end();
        String jsonString = new String(Arrays.copyOfRange((byte[])decompressBytes, (int)0, (int)decompressLength));
        JSONObject jsonObject = new JSONObject(jsonString);
        String sigTLS = jsonObject.getString("TLS.sig");
        byte[] signatureBytes = decoder.decode(sigTLS.getBytes(Charset.forName("UTF-8")));
        try {
            boolean bool;
            String sigTime = jsonObject.getString("TLS.time");
            String sigExpire = jsonObject.getString("TLS.expire_after");
            if (System.currentTimeMillis() / 1000L - Long.parseLong(sigTime) > Long.parseLong(sigExpire)) {
                result.errMessage = new String("TLS sig is out of date ");
                System.out.println("Timeout");
                return result;
            }
            String SerialString = "TLS.appid_at_3rd:" + strAppid3rd + "\nTLS.account_type:" + accountType + "\nTLS.identifier:" + identifier + "\nTLS.sdk_appid:" + skdAppid + "\nTLS.time:" + sigTime + "\nTLS.expire_after:" + sigExpire + "\n";
            CharArrayReader reader = new CharArrayReader(publicKey.toCharArray());
            PEMParser parser = new PEMParser((Reader)reader);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            Object obj = parser.readObject();
            parser.close();
            PublicKey pubKeyStruct = converter.getPublicKey((SubjectPublicKeyInfo)obj);
            Signature signature = Signature.getInstance("SHA256withECDSA", "BC");
            signature.initVerify(pubKeyStruct);
            signature.update(SerialString.getBytes(Charset.forName("UTF-8")));
            result.verifyResult = bool = signature.verify(signatureBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.errMessage = "Failed in checking sig";
        }
        return result;
    }

    public static GenTLSSignatureResult GenTLSSignatureEx(long skdAppid, String identifier, String privStr) throws IOException {
        return TlsSigature.GenTLSSignatureEx(skdAppid, identifier, privStr, 15552000L);
    }

    public static GenTLSSignatureResult GenTLSSignatureEx(long skdAppid, String identifier, String privStr, long expire) throws IOException {
        GenTLSSignatureResult result = new GenTLSSignatureResult();
        Security.addProvider((Provider)new BouncyCastleProvider());
        CharArrayReader reader = new CharArrayReader(privStr.toCharArray());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        PEMParser parser = new PEMParser((Reader)reader);
        Object obj = parser.readObject();
        parser.close();
        PrivateKey privKeyStruct = converter.getPrivateKey((PrivateKeyInfo)obj);
        String jsonString = "{\"TLS.account_type\":\"0\",\"TLS.identifier\":\"" + identifier + "\",\"TLS.appid_at_3rd\":\"" + 0 + "\",\"TLS.sdk_appid\":\"" + skdAppid + "\",\"TLS.expire_after\":\"" + expire + "\",\"TLS.version\": \"201512300000\"}";
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String SerialString = "TLS.appid_at_3rd:0\nTLS.account_type:0\nTLS.identifier:" + identifier + "\nTLS.sdk_appid:" + skdAppid + "\nTLS.time:" + time + "\nTLS.expire_after:" + expire + "\n";
        try {
            String userSig;
            Signature signature = Signature.getInstance("SHA256withECDSA", "BC");
            signature.initSign(privKeyStruct);
            signature.update(SerialString.getBytes(Charset.forName("UTF-8")));
            byte[] signatureBytes = signature.sign();
            String sigTLS = Base64.encodeBase64String((byte[])signatureBytes);
            JSONObject jsonObject = new JSONObject(jsonString);
            jsonObject.put("TLS.sig", (Object)sigTLS);
            jsonObject.put("TLS.time", (Object)time);
            jsonString = jsonObject.toString();
            Deflater compresser = new Deflater();
            compresser.setInput(jsonString.getBytes(Charset.forName("UTF-8")));
            compresser.finish();
            byte[] compressBytes = new byte[512];
            int compressBytesLength = compresser.deflate(compressBytes);
            compresser.end();
            result.urlSig = userSig = new String(base64_url.base64EncodeUrl((byte[])Arrays.copyOfRange((byte[])compressBytes, (int)0, (int)compressBytesLength)));
        }
        catch (Exception e) {
            e.printStackTrace();
            result.errMessage = "generate usersig failed";
        }
        return result;
    }

    public static CheckTLSSignatureResult CheckTLSSignatureEx(String urlSig, long sdkAppid, String identifier, String publicKey) throws DataFormatException {
        CheckTLSSignatureResult result = new CheckTLSSignatureResult();
        Security.addProvider((Provider)new BouncyCastleProvider());
        Base64 decoder = new Base64();
        byte[] compressBytes = base64_url.base64DecodeUrl((byte[])urlSig.getBytes(Charset.forName("UTF-8")));
        Inflater decompression = new Inflater();
        decompression.setInput(compressBytes, 0, compressBytes.length);
        byte[] decompressBytes = new byte[1024];
        int decompressLength = decompression.inflate(decompressBytes);
        decompression.end();
        String jsonString = new String(Arrays.copyOfRange((byte[])decompressBytes, (int)0, (int)decompressLength));
        JSONObject jsonObject = new JSONObject(jsonString);
        String sigTLS = jsonObject.getString("TLS.sig");
        byte[] signatureBytes = decoder.decode(sigTLS.getBytes(Charset.forName("UTF-8")));
        try {
            String strSdkAppid = jsonObject.getString("TLS.sdk_appid");
            String sigTime = jsonObject.getString("TLS.time");
            String sigExpire = jsonObject.getString("TLS.expire_after");
            if ((long)Integer.parseInt(strSdkAppid) != sdkAppid) {
                result.errMessage = new String("sdkappid " + strSdkAppid + " in tls sig not equal sdkappid " + sdkAppid + " in request");
                return result;
            }
            if (System.currentTimeMillis() / 1000L - Long.parseLong(sigTime) > Long.parseLong(sigExpire)) {
                result.errMessage = new String("TLS sig is out of date");
                return result;
            }
            String SerialString = "TLS.appid_at_3rd:0\nTLS.account_type:0\nTLS.identifier:" + identifier + "\nTLS.sdk_appid:" + sdkAppid + "\nTLS.time:" + sigTime + "\nTLS.expire_after:" + sigExpire + "\n";
            CharArrayReader reader = new CharArrayReader(publicKey.toCharArray());
            PEMParser parser = new PEMParser((Reader)reader);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            Object obj = parser.readObject();
            parser.close();
            PublicKey pubKeyStruct = converter.getPublicKey((SubjectPublicKeyInfo)obj);
            Signature signature = Signature.getInstance("SHA256withECDSA", "BC");
            signature.initVerify(pubKeyStruct);
            signature.update(SerialString.getBytes(Charset.forName("UTF-8")));
            boolean bool = signature.verify(signatureBytes);
            result.expireTime = Integer.parseInt(sigExpire);
            result.initTime = Integer.parseInt(sigTime);
            result.verifyResult = bool;
        }
        catch (Exception e) {
            e.printStackTrace();
            result.errMessage = "Failed in checking sig";
        }
        return result;
    }

    public static String getAuthKey() {
        return authKey;
    }

    public static void setAuthKey(String authKey) {
        TlsSigature.authKey = authKey;
    }

    public static String getAppId() {
        return appId;
    }

    public static void setAppId(String appId) {
        TlsSigature.appId = appId;
    }

    public static String getPrivateKey() {
        return privateKey;
    }

    public static void setPrivateKey(String privateKey) {
        TlsSigature.privateKey = privateKey;
    }

    public static class CheckTLSSignatureResult {
        public String errMessage = "";
        public boolean verifyResult = false;
        public int expireTime;
        public int initTime;
    }

    public static class GenTLSSignatureResult {
        public String errMessage = "";
        public String urlSig = "";
        public int expireTime;
        public int initTime;
    }
}

