/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.common.tool;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientUtil.class);
    private static HttpClient defaultClient = HttpClientUtil.createHttpClient(200, 20, 5000, 5000, 3000);

    private HttpClientUtil() {
    }

    public static HttpClient createHttpClient(int maxTotal, int maxPerRoute, int socketTimeout, int connectTimeout, int connectionRequestTimeout) {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(maxTotal);
        cm.setDefaultMaxPerRoute(maxPerRoute);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(defaultRequestConfig).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(HttpClient httpClient, String url, Map<String, String> params, Charset encoding) {
        String resp = "";
        HttpPost httpPost = new HttpPost(url);
        if (params != null && params.size() > 0) {
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(formParams, encoding);
            httpPost.setEntity((HttpEntity)postEntity);
        }
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)httpPost);
            resp = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)encoding);
        }
        catch (IOException e) {
            LOG.warn("\u53d1\u9001post\u8bf7\u6c42\u5931\u8d25,url={}", (Object)url, (Object)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOG.warn("\u5173\u95edresponse\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostJson(String url, String json, Header ... headers) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeaders(headers);
        httpPost.addHeader("Content-Type", "application/json;charset=utf-8");
        httpPost.setEntity((HttpEntity)new StringEntity(json, Charset.forName("UTF-8")));
        CloseableHttpResponse response = null;
        String resp = "";
        try {
            response = (CloseableHttpResponse)defaultClient.execute((HttpUriRequest)httpPost);
            resp = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("utf8"));
        }
        catch (IOException e) {
            LOG.warn("\u53d1\u9001post\u8bf7\u6c42\u5931\u8d25,url={}", (Object)url, (Object)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOG.warn("\u5173\u95edresponse\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return resp;
    }

    public static String sendPost(String url, Map<String, String> params) {
        Charset encoding = Charset.forName("utf8");
        return HttpClientUtil.sendPost(defaultClient, url, params, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGet(HttpClient httpClient, String url, Charset encoding) {
        HttpGet httpget = new HttpGet(url);
        String resp = "";
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)httpget);
            resp = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)encoding);
        }
        catch (IOException e) {
            LOG.warn("\u53d1\u9001get\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOG.warn("\u5173\u95edresponse\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return resp;
    }

    public static String sendGet(String url) {
        Charset encoding = Charset.forName("utf8");
        return HttpClientUtil.sendGet(defaultClient, url, encoding);
    }
}

