/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.common.tool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetryFragment<T> {
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final int DEFAULT_RETRY_INTERVAL_MS = 200;
    private int retryCount = 3;
    private int intervalMs = 200;
    private Logger logger = LoggerFactory.getLogger(cn.com.wawa.proxy.api.bean.RetryFragment.class);

    public RetryFragment() {
    }

    public RetryFragment(int retryCount, int intervalMs) {
        this.retryCount = retryCount;
        this.intervalMs = intervalMs;
    }

    protected abstract T codeFragment();

    public T invoke() throws Exception {
        return this.invoke(0);
    }

    private T invoke(int initTimes) throws Exception {
        T t = null;
        Exception lastException = null;
        boolean validResult = false;
        for (int i = initTimes; i < this.retryCount; ++i) {
            try {
                t = this.codeFragment();
                validResult = this.validValue(t);
                if (validResult) {
                    break;
                }
            }
            catch (Exception ex) {
                lastException = ex;
                this.logger.error("retry_fragment execution times:{}, exception:{}", (Object)i, (Object)ex.getMessage());
            }
            this.logger.warn("retry_fragment execution times:{}, validResult:{}", (Object)i, (Object)validResult);
            this.sleep(this.intervalMs);
        }
        if (validResult) {
            return t;
        }
        if (lastException != null && t == null) {
            throw new Exception("\u91cd\u8bd5\u5f02\u5e38");
        }
        return t;
    }

    protected boolean validValue(T t) {
        return true;
    }

    private void sleep(int sleepMs) {
        if (sleepMs <= 0) {
            return;
        }
        try {
            Thread.sleep(sleepMs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

