/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.common.tool;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class Crypt {
    private static final String TAG = "#Crypt";
    public static final int KEYLEN = 16;
    private static final int ROUNDS = 16;
    private static final int LOG_ROUNDS = 4;
    private static final long DELTA = 2654435769L;
    private static final long BASE = 0xFFFFFFFFL;
    public static int SALT_LEN = 2;
    public static int ZERO_LEN = 7;
    private static final int expired = 86400;
    private static int sdkappid;
    private static String key;
    private static final Cache<String, String> baiqiLogisticsLocalCache;

    public static synchronized String hFiveEncrypt(String roomId) {
        String sig = (String)baiqiLogisticsLocalCache.getIfPresent((Object)roomId);
        if (StringUtils.isNotBlank((CharSequence)sig)) {
            return sig;
        }
        ByteBuffer src = ByteBuffer.allocate(13);
        src.put((byte)2);
        src.putInt(sdkappid);
        src.putInt(Integer.valueOf(roomId));
        int now = (int)(new Date().getTime() / 1000L);
        src.putInt(now + 86400);
        src.flip();
        ByteBuffer encBuffer = ByteBuffer.allocate(50);
        int len = Crypt.encrypt((byte)1, src, 13, key.getBytes(), encBuffer);
        byte[] encBytes = new byte[len];
        encBuffer.get(encBytes, 0, encBytes.length);
        String newSig = Crypt.bytesToHexString(encBytes);
        baiqiLogisticsLocalCache.put((Object)roomId, (Object)newSig);
        return newSig;
    }

    public static synchronized int encrypt(byte version, ByteBuffer inputBuffer, int inputBufferLen, byte[] key, ByteBuffer outputBuffer) {
        int j;
        if (version != 1 && version != 2) {
            throw new RuntimeException("version must be 1 or 2");
        }
        if (key.length != 16) {
            return -1;
        }
        ByteBuffer keyBuf = ByteBuffer.allocate(16);
        for (int i = 0; i < 16; ++i) {
            keyBuf.put(i, key[i]);
        }
        int inputIndex = 0;
        int outputIndex = 0;
        int nPadSaltBodyZeroLen = inputBufferLen + 1 + SALT_LEN + ZERO_LEN;
        int nPadLen = nPadSaltBodyZeroLen % 8;
        nPadLen = nPadLen == 0 ? nPadLen : 8 - nPadLen;
        ByteBuffer srcBuf = ByteBuffer.allocate(8);
        int srcIndex = 0;
        srcBuf.put(srcIndex++, (byte)((int)(Math.random() * 255.0) & 0xF8 | nPadLen));
        while (nPadLen-- > 0) {
            srcBuf.put(srcIndex++, (byte)(Math.random() * 255.0));
        }
        ByteBuffer prev_plainTeaBufBlock = ByteBuffer.allocate(8);
        ByteBuffer prev_cryptBufBlock = ByteBuffer.allocate(8);
        for (int i = 0; i < 8; ++i) {
            prev_plainTeaBufBlock.put(i, (byte)0);
            prev_cryptBufBlock.put(i, (byte)0);
        }
        ByteBuffer block = ByteBuffer.allocate(8);
        int i = 0;
        while (i < SALT_LEN) {
            if (srcIndex < 8) {
                srcBuf.put(srcIndex++, (byte)(Math.random() * 255.0));
                ++i;
            }
            if (srcIndex != 8) continue;
            Crypt.encryptBlock(version, keyBuf, srcBuf, prev_plainTeaBufBlock, prev_cryptBufBlock, block);
            for (j = 0; j < 8; ++j) {
                outputBuffer.put(outputIndex++, block.get(j));
            }
            srcIndex = 0;
        }
        while (inputBufferLen > 0) {
            if (srcIndex < 8) {
                srcBuf.put(srcIndex++, inputBuffer.get(inputIndex++));
                --inputBufferLen;
            }
            if (srcIndex != 8) continue;
            Crypt.encryptBlock(version, keyBuf, srcBuf, prev_plainTeaBufBlock, prev_cryptBufBlock, block);
            for (int j2 = 0; j2 < 8; ++j2) {
                outputBuffer.put(outputIndex++, block.get(j2));
            }
            srcIndex = 0;
        }
        i = 0;
        while (i < ZERO_LEN) {
            if (srcIndex < 8) {
                srcBuf.put(srcIndex++, (byte)0);
                ++i;
            }
            if (srcIndex != 8) continue;
            Crypt.encryptBlock(version, keyBuf, srcBuf, prev_plainTeaBufBlock, prev_cryptBufBlock, block);
            for (j = 0; j < 8; ++j) {
                outputBuffer.put(outputIndex++, block.get(j));
            }
            srcIndex = 0;
        }
        return outputIndex;
    }

    private static void encryptBlock(byte version, ByteBuffer key, ByteBuffer plainBufBlock, ByteBuffer prev_plainTeaBufBlock, ByteBuffer prev_cryptBufBlock, ByteBuffer cryptBufBlock) {
        int j;
        ByteBuffer cryptTeaBufBlock = ByteBuffer.allocate(8);
        ByteBuffer plainTeaBufBlock = ByteBuffer.allocate(8);
        for (j = 0; j < 8; ++j) {
            plainTeaBufBlock.put(j, (byte)(plainBufBlock.get(j) ^ prev_cryptBufBlock.get(j)));
        }
        Crypt.teaEncryptECB(plainTeaBufBlock, key, cryptTeaBufBlock);
        for (j = 0; j < 8; ++j) {
            if (version == 1) {
                cryptBufBlock.put(j, cryptTeaBufBlock.get(j));
                continue;
            }
            cryptBufBlock.put(j, (byte)(cryptTeaBufBlock.get(j) ^ prev_plainTeaBufBlock.get(j)));
        }
        for (j = 0; j < 8; ++j) {
            prev_plainTeaBufBlock.put(j, plainTeaBufBlock.get(j));
            prev_cryptBufBlock.put(j, cryptBufBlock.get(j));
        }
    }

    private static void teaEncryptECB(ByteBuffer inBuf, ByteBuffer key, ByteBuffer outBuf) {
        long y = (long)inBuf.getInt(0) & 0xFFFFFFFFL;
        long z = (long)inBuf.getInt(4) & 0xFFFFFFFFL;
        long[] k = new long[4];
        for (int i = 0; i < 4; ++i) {
            k[i] = (long)key.getInt(i * 4) & 0xFFFFFFFFL;
        }
        long sum = 0L;
        for (int i = 0; i < 16; ++i) {
            sum = sum + 2654435769L & 0xFFFFFFFFL;
            y = y + ((z << 4) + k[0] ^ z + sum ^ (z >> 5) + k[1]) & 0xFFFFFFFFL;
            z = z + ((y << 4) + k[2] ^ y + sum ^ (y >> 5) + k[3]) & 0xFFFFFFFFL;
        }
        outBuf.putInt(0, (int)y);
        outBuf.putInt(4, (int)z);
    }

    public static int encryptLen(int dataLen) {
        int length = dataLen + 1 + SALT_LEN + ZERO_LEN;
        int nPadLen = length % 8;
        nPadLen = nPadLen == 0 ? nPadLen : 8 - nPadLen;
        return length + nPadLen;
    }

    public static synchronized int decrypt(byte version, ByteBuffer inputBuffer, int inputBufferLen, byte[] key, ByteBuffer outputBuffer) {
        if (version != 1 && version != 2) {
            throw new RuntimeException("version must be 1 or 2");
        }
        if (key.length != 16) {
            return -1;
        }
        ByteBuffer keyBuf = ByteBuffer.allocate(16);
        for (int i = 0; i < 16; ++i) {
            keyBuf.put(i, key[i]);
        }
        int inputIndex = 0;
        int outputIndex = 0;
        if (inputBufferLen % 8 != 0 || inputBufferLen < 16) {
            System.out.println("inputBufferLen is not correct, inputBufferLen = " + inputBufferLen);
            return -1;
        }
        ByteBuffer prev_cryptBufBlock = ByteBuffer.allocate(8);
        ByteBuffer prev_plainTeaBufBlock = ByteBuffer.allocate(8);
        for (int i = 0; i < 8; ++i) {
            prev_cryptBufBlock.put(i, (byte)0);
            prev_plainTeaBufBlock.put(i, (byte)0);
        }
        ByteBuffer block = ByteBuffer.allocate(8);
        Crypt.decryptBlock(version, keyBuf, inputBuffer, prev_cryptBufBlock, prev_plainTeaBufBlock, block);
        int nPadLen = block.get(0) & 7;
        int outputBufferLen = inputBufferLen - 1 - nPadLen - SALT_LEN - ZERO_LEN;
        if (outputBufferLen < 0) {
            System.out.println("outputBufferLen is not correct, outputBufferLen = " + outputBufferLen);
            return -1;
        }
        int beginIndex = 0;
        int endIndex = 8;
        if (1 + nPadLen + SALT_LEN < 8) {
            inputIndex = 1 + nPadLen + SALT_LEN;
            for (int i = 0; i < 8 - (1 + nPadLen + SALT_LEN); ++i) {
                outputBuffer.put(outputIndex++, block.get(inputIndex + i));
            }
            inputIndex = 8;
        } else {
            beginIndex = 1 + nPadLen + SALT_LEN - 8;
            inputIndex = 8;
        }
        ByteBuffer srcBuf = ByteBuffer.allocate(8);
        int srcIndex = 0;
        while (inputIndex < inputBufferLen) {
            if (srcIndex < 8) {
                srcBuf.put(srcIndex, inputBuffer.get(inputIndex));
                ++srcIndex;
                ++inputIndex;
            }
            if (srcIndex != 8) continue;
            Crypt.decryptBlock(version, keyBuf, srcBuf, prev_cryptBufBlock, prev_plainTeaBufBlock, block);
            for (int i = beginIndex; i < endIndex; ++i) {
                outputBuffer.put(outputIndex++, block.get(i));
            }
            beginIndex = 0;
            if (outputIndex + 1 == outputBufferLen + 8 - ZERO_LEN - 1) {
                endIndex = 8 - ZERO_LEN;
            }
            srcIndex = 0;
        }
        return outputIndex;
    }

    private static void decryptBlock(byte version, ByteBuffer key, ByteBuffer cryptBufBlock, ByteBuffer prev_cryptBufBlock, ByteBuffer prev_plainTeaBufBlock, ByteBuffer plainBufBlock) {
        int j;
        ByteBuffer cryptTeaBufBlock = ByteBuffer.allocate(8);
        ByteBuffer plainTeaBufBlock = ByteBuffer.allocate(8);
        for (j = 0; j < 8; ++j) {
            if (version == 1) {
                cryptTeaBufBlock.put(j, cryptBufBlock.get(j));
                continue;
            }
            cryptTeaBufBlock.put(j, (byte)(cryptBufBlock.get(j) ^ prev_plainTeaBufBlock.get(j)));
        }
        Crypt.teaDecryptECB(cryptTeaBufBlock, key, plainTeaBufBlock);
        for (j = 0; j < 8; ++j) {
            plainBufBlock.put(j, (byte)(plainTeaBufBlock.get(j) ^ prev_cryptBufBlock.get(j)));
        }
        for (j = 0; j < 8; ++j) {
            prev_plainTeaBufBlock.put(j, plainTeaBufBlock.get(j));
            prev_cryptBufBlock.put(j, cryptBufBlock.get(j));
        }
    }

    private static void teaDecryptECB(ByteBuffer inBuf, ByteBuffer key, ByteBuffer outBuf) {
        long y = (long)inBuf.getInt(0) & 0xFFFFFFFFL;
        long z = (long)inBuf.getInt(4) & 0xFFFFFFFFL;
        long[] k = new long[4];
        for (int i = 0; i < 4; ++i) {
            k[i] = key.getInt(i * 4);
        }
        long sum = 3816266640L;
        for (int i = 0; i < 16; ++i) {
            z = z - ((y << 4) + k[2] ^ y + sum ^ (y >> 5) + k[3]) & 0xFFFFFFFFL;
            y = y - ((z << 4) + k[0] ^ z + sum ^ (z >> 5) + k[1]) & 0xFFFFFFFFL;
            sum = sum - 2654435769L & 0xFFFFFFFFL;
        }
        outBuf.putInt(0, (int)y);
        outBuf.putInt(4, (int)z);
    }

    public static byte[] hexToBytes(String s) {
        s = s.toUpperCase();
        int len = s.length() / 2;
        int ii = 0;
        byte[] bs = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c;
            int h = (c = s.charAt(ii++)) <= '9' ? c - 48 : c - 65 + 10;
            h <<= 4;
            h = (c = s.charAt(ii++)) <= '9' ? (h |= c - 48) : (h |= c - 65 + 10);
            bs[i] = (byte)h;
        }
        return bs;
    }

    public static final String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        int sdkappid = 1400050371;
        int groupid = 59;
        int expired = 86400;
        String key = "b4ab83d6c1b43dde";
        ByteBuffer src = ByteBuffer.allocate(13);
        src.put((byte)2);
        src.putInt(sdkappid);
        src.putInt(groupid);
        int now = (int)(new Date().getTime() / 1000L);
        System.out.println(now + expired);
        src.putInt(now + expired);
        src.flip();
        ByteBuffer encBuffer = ByteBuffer.allocate(50);
        int len = Crypt.encrypt((byte)1, src, 13, key.getBytes(), encBuffer);
        byte[] encBytes = new byte[len];
        encBuffer.get(encBytes, 0, encBytes.length);
        System.out.println(Crypt.bytesToHexString(encBytes));
        ByteBuffer srcBuffer = ByteBuffer.allocate(13);
        Crypt.decrypt((byte)1, ByteBuffer.wrap(encBytes), encBytes.length, key.getBytes(), srcBuffer);
        srcBuffer.order(ByteOrder.BIG_ENDIAN);
        System.out.println(srcBuffer.get());
        System.out.println(srcBuffer.getInt());
        System.out.println(srcBuffer.getInt());
        System.out.println(srcBuffer.getInt());
    }

    public static int getSdkappid() {
        return sdkappid;
    }

    public static void setSdkappid(int sdkappid) {
        Crypt.sdkappid = sdkappid;
    }

    public static String getKey() {
        return key;
    }

    public static void setKey(String key) {
        Crypt.key = key;
    }

    static {
        baiqiLogisticsLocalCache = CacheBuilder.newBuilder().maximumSize(5L).expireAfterWrite(60L, TimeUnit.MINUTES).build();
    }
}

