/**
 * Project Name:wawa-service-common
 * File Name:YunpianClient.java
 * Package Name:cn.com.wawa.common.tool
 * Date:2017年11月23日下午9:38:24
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.wawa.common.tool;

import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;

/**
 * ClassName:YunpianClient <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2017年11月23日 下午9:38:24 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class YunpianClient {

    private static final Logger LOGGER = LoggerFactory.getLogger(YunpianClient.class);

    private static final String               SMS_URL="https://sms.yunpian.com/v2/sms/single_send.json";

    private static final String               APIKEY="dd66615d922f2519ff134c0df909e505";

    public static boolean smsSendByParam(String template, Map<String, String> param, String mobile) {
        String context = SimpleTemplateUtil.render(template, param);
        return smsSend(context,mobile);
    }


    private static boolean smsSend(String context,String mobile){
        Map<String, String> params = Maps.newHashMap();
        params.put("apikey", APIKEY);
        params.put("text", context);
        params.put("mobile", mobile);
        Integer returnCode = -1;
        try {
            String resp = HttpClientUtil.sendPost(SMS_URL, params);
            if (StringUtils.isNotBlank(resp)) {
                JSONObject json = JSON.parseObject(resp);
                returnCode = json.getInteger("code");
                if (returnCode != 0) {
                    LOGGER.warn("云片发送短信异常， mobile={}, text={}, resp={}", mobile, context, resp);
                }
            }
        } catch (Exception e) {
            LOGGER.warn("云片发送短信失败：mobile={}",mobile, e);
        }
        return returnCode == 0;
    }
}

