/**
 * Project Name:wawa-service-common File Name:BeeplayUtil.java Package Name:cn.com.wawa.common.tool
 * Date:2017年12月22日下午1:50:18 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.wawa.common.tool;

import java.util.Arrays;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

/**
 * ClassName:BeeplayUtil <br/>
 * Date: 2017年12月22日 下午1:50:18 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class BeeplayUtil {

    /** 分配给用户的私钥 */
    private static String secretKey;

    /** 玩蜂用户认证接口 */
    private static String requestUrl;

    public static boolean tokenVerify(Map<String, String> params, String sign) {
        String wawaSign = getsign(params);
        return StringUtils.equals(sign, wawaSign);
    }

    /**
     * 拼接字符串，内容MD5加密
     *
     * @param params
     * @return MD5加密后的字符串
     */
    public static String getsign(Map<String, String> params) {
        Object[] keyArr = params.keySet().toArray();
        StringBuilder signString = new StringBuilder();
        Arrays.sort(keyArr);
        for (Object key : keyArr) {
            signString.append(key).append("=").append(params.get(key)).append("&");
        }
        signString.append("key=").append(secretKey);
        return MD5.md5(signString.toString()).toUpperCase();
    }
    
    /**
     * secretKey.
     *
     * @return the secretKey
     */
    public static String getSecretKey() {
        return secretKey;
    }

    /**
     * secretKey.
     *
     * @param secretKey the secretKey to set
     */
    public static void setSecretKey(String secretKey) {
        BeeplayUtil.secretKey = secretKey;
    }

    /**
     * requestUrl.
     *
     * @return the requestUrl
     */
    public static String getRequestUrl() {
        return requestUrl;
    }

    /**
     * requestUrl.
     *
     * @param requestUrl the requestUrl to set
     */
    public static void setRequestUrl(String requestUrl) {
        BeeplayUtil.requestUrl = requestUrl;
    }

}
