package cn.com.wawa.common.tool;

/**
 * @author wfh
 * @date 2018/6/28
 */
public class MoneyUtils {

    /**
     * 人民币和抓抓币汇率 目前为1：10
     */
    public static final Long RATE = 10L;

    /**
     * 元转分
     * @param yuan
     * @return
     */
    public static long yuan2Fen(long yuan){
        return yuan * 100;
    }

    /**
     * 分转元
     * @param fen
     * @return
     */
    public static long fen2Yuan(long fen){
        return fen / 100;
    }

    /**
     * 分转元，如果为fen为空时，直接返回0
     * @param fen
     * @return
     */
    public static long fen2YuanDefaultZero(Long fen){
        if( null == fen){
            return 0L;
        }
        return fen / 100;
    }

    /**
     * 分转抓抓币，如果为fen为空时，直接返回0
     * @param fen
     * @return
     */
    public static long fen2CoinDefaultZero(Long fen){
        if( null == fen){
            return 0L;
        }
        return fen / MoneyUtils.RATE;
    }

    /**
     * 分转抓抓币，如果为fen为空时，直接返回0
     * @param fen
     * @return
     */
    public static long fen2CoinDefaultZeroForRedPackage(Long fen){
        return fen2YuanDefaultZero(fen) * MoneyUtils.RATE ;
    }

    /**
     * 元转抓抓币，yuan，直接返回0
     * @param yuan
     * @return
     */
    public static long yuan2CoinDefaultZero(Long yuan){
        if(yuan == null){
            return 0;
        }
        return yuan * MoneyUtils.RATE ;
    }
}
