package cn.com.wawa.common.tool;

import cn.com.wawa.common.bean.ValueRateBean;
import cn.com.wawa.common.exception.RandomRateErrorException;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 说明:
 *
 * @author hillchen
 * @create 2018-07-14 16:13
 **/
public class RateUtil {
    private RateUtil(){}
    /**
     * 根据一个权重列表随机获得一个
     * @param rates
     * @return
     */
    public static int randomRateIndex(List<Integer> rates){
        try{
            int totalRate = 0;
            for(Integer rate : rates){
                totalRate += rate;
            }

            int random = RandomUtils.random(totalRate,1);
            int lestRate = totalRate;
            int index = 0;
            for(Integer rate : rates){
                lestRate -= rate;
                if(lestRate < random){
                    return index;
                }
                index ++;
            }
        }catch (Exception e){
            throw new RandomRateErrorException(e);
        }

        throw new RandomRateErrorException("根据权重生成随机数失败");
    }

    public static <T>T randomRateValue(List<ValueRateBean<T>> valueRates){
        try{
            int totalRate = 0;
            List<Integer> rates = new ArrayList<>(valueRates.size());
            Map<Integer,T> indexValueMap = new HashMap<>(valueRates.size());
            int index = 0;
            for(ValueRateBean<T> valueRateBean : valueRates){
                Integer rate = valueRateBean.getRate();
                T value = valueRateBean.getValue();
                totalRate += rate;
                rates.add(rate);
                indexValueMap.put(index,value);
                index ++;
            }

            int random = RandomUtils.random(totalRate,1);
            int lestRate = totalRate;
            index = 0;
            for(Integer rate : rates){
                lestRate -= rate;
                if(lestRate < random){
                    return indexValueMap.get(index);
                }
                index ++;
            }
        }catch (Exception e){
            throw new RandomRateErrorException(e);
        }

        throw new RandomRateErrorException("根据权重生成随机数失败");
    }

}
