package cn.com.wawa.common.tool;

import cn.com.duiba.wolf.utils.SwitchUtils;

/**
 * Created by xiaoxuda on 2017/6/28.
 */
public class SwitchTool {

    /**
     * 更新开关集合中由switchCode指定位置的开关状态，status为true时设置为开，status为false时设置为关
     * @param switches
     * @param switchCode
     * @param status
     * @return
     */
    public static int updateSwitch(Integer switches, Integer switchCode, boolean status){
        if(status){
            switches = SwitchUtils.openSwitch(switches, switchCode);
        }else{
            switches = SwitchUtils.closeSwitch(switches, switchCode);
        }
        return switches;
    }

    /**
     * 更新开关集合中由switchCode指定位置的开关状态，status为true时设置为开，status为false时设置为关
     * @param switches
     * @param switchCode
     * @param status
     * @return
     */
    public static long updateSwitch(Long switches, Integer switchCode, boolean status){
        if(status){
            switches = SwitchUtils.openSwitch(switches, switchCode);
        }else{
            switches = SwitchUtils.closeSwitch(switches, switchCode);
        }
        return switches;
    }

    public static boolean isUserSwitch(Long switches, int binarySwitchLocation) {
        long v = 1 << binarySwitchLocation;
        long ret = switches & v;
        return ret != 0;
    }

    public static void main(String[] args) {
        System.out.println(updateSwitch(33L, 3, true));
    }
}
