/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.common.tool;

import cn.com.wawa.common.exception.CheckCryptVersionErrorException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crypt {
    private static final Logger LOG = LoggerFactory.getLogger(Crypt.class);
    public static final int KEYLEN = 16;
    private static final int ROUNDS = 16;
    private static final int LOG_ROUNDS = 4;
    private static final long DELTA = 2654435769L;
    private static final long BASE = 0xFFFFFFFFL;
    private static final int SALT_LEN = 2;
    private static final int ZERO_LEN = 7;
    private static final int EXPIRED = 86400;
    private static int sdkappid;
    private static String key;
    private static final Random RANDOM;
    private static final Cache<String, String> baiqiLogisticsLocalCache;

    private Crypt() {
    }

    public static synchronized String hFiveEncrypt(String roomId) {
        String sig = (String)baiqiLogisticsLocalCache.getIfPresent((Object)roomId);
        if (StringUtils.isNotBlank((CharSequence)sig)) {
            return sig;
        }
        ByteBuffer src = ByteBuffer.allocate(13);
        src.put((byte)2);
        src.putInt(sdkappid);
        src.putInt(Integer.valueOf(roomId));
        int now = (int)(new Date().getTime() / 1000L);
        src.putInt(now + 86400);
        src.flip();
        ByteBuffer encBuffer = ByteBuffer.allocate(50);
        int len = Crypt.encrypt((byte)1, src, 13, key.getBytes(), encBuffer);
        byte[] encBytes = new byte[len];
        encBuffer.get(encBytes, 0, encBytes.length);
        String newSig = Crypt.bytesToHexString(encBytes);
        baiqiLogisticsLocalCache.put((Object)roomId, (Object)newSig);
        return newSig;
    }

    public static synchronized int encrypt(byte version, ByteBuffer inputBuffer, int inputBufferLen, byte[] key, ByteBuffer outputBuffer) {
        int j;
        Crypt.checkCryptVersion(version);
        if (key.length != 16) {
            return -1;
        }
        ByteBuffer keyBuf = ByteBuffer.allocate(16);
        for (int i = 0; i < 16; ++i) {
            keyBuf.put(i, key[i]);
        }
        int inputIndex = 0;
        int outputIndex = 0;
        int nPadSaltBodyZeroLen = inputBufferLen + 1 + 2 + 7;
        int nPadLen = nPadSaltBodyZeroLen % 8;
        nPadLen = nPadLen == 0 ? nPadLen : 8 - nPadLen;
        ByteBuffer srcBuf = ByteBuffer.allocate(8);
        int srcIndex = 0;
        srcBuf.put(srcIndex++, (byte)(RANDOM.nextInt(255) & 0xF8 | nPadLen));
        while (nPadLen-- > 0) {
            srcBuf.put(srcIndex++, (byte)RANDOM.nextInt(255));
        }
        ByteBuffer prevPlainTeaBufBlock = ByteBuffer.allocate(8);
        ByteBuffer prevCryptBufBlock = ByteBuffer.allocate(8);
        for (int i = 0; i < 8; ++i) {
            prevPlainTeaBufBlock.put(i, (byte)0);
            prevCryptBufBlock.put(i, (byte)0);
        }
        ByteBuffer block = ByteBuffer.allocate(8);
        int saltLen = 0;
        while (saltLen < 2) {
            if (srcIndex < 8) {
                srcBuf.put(srcIndex++, (byte)(Math.random() * 255.0));
                ++saltLen;
            }
            if (srcIndex != 8) continue;
            Crypt.encryptBlock(version, keyBuf, srcBuf, prevPlainTeaBufBlock, prevCryptBufBlock, block);
            for (j = 0; j < 8; ++j) {
                outputBuffer.put(outputIndex++, block.get(j));
            }
            srcIndex = 0;
        }
        while (inputBufferLen > 0) {
            if (srcIndex < 8) {
                srcBuf.put(srcIndex++, inputBuffer.get(inputIndex++));
                --inputBufferLen;
            }
            if (srcIndex != 8) continue;
            Crypt.encryptBlock(version, keyBuf, srcBuf, prevPlainTeaBufBlock, prevCryptBufBlock, block);
            for (j = 0; j < 8; ++j) {
                outputBuffer.put(outputIndex++, block.get(j));
            }
            srcIndex = 0;
        }
        int zeroLen = 0;
        while (zeroLen < 7) {
            if (srcIndex < 8) {
                srcBuf.put(srcIndex++, (byte)0);
                ++zeroLen;
            }
            if (srcIndex != 8) continue;
            Crypt.encryptBlock(version, keyBuf, srcBuf, prevPlainTeaBufBlock, prevCryptBufBlock, block);
            for (int j2 = 0; j2 < 8; ++j2) {
                outputBuffer.put(outputIndex++, block.get(j2));
            }
            srcIndex = 0;
        }
        return outputIndex;
    }

    private static void checkCryptVersion(byte version) {
        if (version != 1 && version != 2) {
            throw new CheckCryptVersionErrorException("version must be 1 or 2");
        }
    }

    private static void encryptBlock(byte version, ByteBuffer key, ByteBuffer plainBufBlock, ByteBuffer prevPlainTeaBufBlock, ByteBuffer prevCryptBufBlock, ByteBuffer cryptBufBlock) {
        int j;
        ByteBuffer cryptTeaBufBlock = ByteBuffer.allocate(8);
        ByteBuffer plainTeaBufBlock = ByteBuffer.allocate(8);
        for (j = 0; j < 8; ++j) {
            plainTeaBufBlock.put(j, (byte)(plainBufBlock.get(j) ^ prevCryptBufBlock.get(j)));
        }
        Crypt.teaEncryptECB(plainTeaBufBlock, key, cryptTeaBufBlock);
        for (j = 0; j < 8; ++j) {
            if (version == 1) {
                cryptBufBlock.put(j, cryptTeaBufBlock.get(j));
                continue;
            }
            cryptBufBlock.put(j, (byte)(cryptTeaBufBlock.get(j) ^ prevPlainTeaBufBlock.get(j)));
        }
        for (j = 0; j < 8; ++j) {
            prevPlainTeaBufBlock.put(j, plainTeaBufBlock.get(j));
            prevCryptBufBlock.put(j, cryptBufBlock.get(j));
        }
    }

    private static void teaEncryptECB(ByteBuffer inBuf, ByteBuffer key, ByteBuffer outBuf) {
        long y = (long)inBuf.getInt(0) & 0xFFFFFFFFL;
        long z = (long)inBuf.getInt(4) & 0xFFFFFFFFL;
        long[] k = new long[4];
        for (int i = 0; i < 4; ++i) {
            k[i] = (long)key.getInt(i * 4) & 0xFFFFFFFFL;
        }
        long sum = 0L;
        for (int i = 0; i < 16; ++i) {
            sum = sum + 2654435769L & 0xFFFFFFFFL;
            y = y + ((z << 4) + k[0] ^ z + sum ^ (z >> 5) + k[1]) & 0xFFFFFFFFL;
            z = z + ((y << 4) + k[2] ^ y + sum ^ (y >> 5) + k[3]) & 0xFFFFFFFFL;
        }
        outBuf.putInt(0, (int)y);
        outBuf.putInt(4, (int)z);
    }

    public static int encryptLen(int dataLen) {
        int length = dataLen + 1 + 2 + 7;
        int nPadLen = length % 8;
        nPadLen = nPadLen == 0 ? nPadLen : 8 - nPadLen;
        return length + nPadLen;
    }

    public static synchronized int decrypt(byte version, ByteBuffer inputBuffer, int inputBufferLen, byte[] key, ByteBuffer outputBuffer) {
        int inputIndex;
        Crypt.checkCryptVersion(version);
        if (key.length != 16) {
            return -1;
        }
        ByteBuffer keyBuf = ByteBuffer.allocate(16);
        for (int i = 0; i < 16; ++i) {
            keyBuf.put(i, key[i]);
        }
        int outputIndex = 0;
        if (inputBufferLen % 8 != 0 || inputBufferLen < 16) {
            LOG.warn(String.format("inputBufferLen is not correct, inputBufferLen = {0}", inputBufferLen));
            return -1;
        }
        ByteBuffer prevCryptBufBlock = ByteBuffer.allocate(8);
        ByteBuffer prevPlainTeaBufBlock = ByteBuffer.allocate(8);
        for (int i = 0; i < 8; ++i) {
            prevCryptBufBlock.put(i, (byte)0);
            prevPlainTeaBufBlock.put(i, (byte)0);
        }
        ByteBuffer block = ByteBuffer.allocate(8);
        Crypt.decryptBlock(version, keyBuf, inputBuffer, prevCryptBufBlock, prevPlainTeaBufBlock, block);
        int nPadLen = block.get(0) & 7;
        int outputBufferLen = inputBufferLen - 1 - nPadLen - 2 - 7;
        if (outputBufferLen < 0) {
            LOG.warn(String.format("outputBufferLen is not correct, outputBufferLen = {0} ", outputBufferLen));
            return -1;
        }
        int beginIndex = 0;
        int endIndex = 8;
        if (1 + nPadLen + 2 < 8) {
            inputIndex = 1 + nPadLen + 2;
            for (int i = 0; i < 8 - (1 + nPadLen + 2); ++i) {
                outputBuffer.put(outputIndex++, block.get(inputIndex + i));
            }
            inputIndex = 8;
        } else {
            beginIndex = 1 + nPadLen + 2 - 8;
            inputIndex = 8;
        }
        ByteBuffer srcBuf = ByteBuffer.allocate(8);
        int srcIndex = 0;
        while (inputIndex < inputBufferLen) {
            if (srcIndex < 8) {
                srcBuf.put(srcIndex, inputBuffer.get(inputIndex));
                ++srcIndex;
                ++inputIndex;
            }
            if (srcIndex != 8) continue;
            Crypt.decryptBlock(version, keyBuf, srcBuf, prevCryptBufBlock, prevPlainTeaBufBlock, block);
            for (int i = beginIndex; i < endIndex; ++i) {
                outputBuffer.put(outputIndex++, block.get(i));
            }
            beginIndex = 0;
            if (outputIndex + 1 == outputBufferLen + 8 - 7 - 1) {
                endIndex = 1;
            }
            srcIndex = 0;
        }
        return outputIndex;
    }

    private static void decryptBlock(byte version, ByteBuffer key, ByteBuffer cryptBufBlock, ByteBuffer prevCryptBufBlock, ByteBuffer prevPlainTeaBufBlock, ByteBuffer plainBufBlock) {
        int j;
        ByteBuffer cryptTeaBufBlock = ByteBuffer.allocate(8);
        ByteBuffer plainTeaBufBlock = ByteBuffer.allocate(8);
        for (j = 0; j < 8; ++j) {
            if (version == 1) {
                cryptTeaBufBlock.put(j, cryptBufBlock.get(j));
                continue;
            }
            cryptTeaBufBlock.put(j, (byte)(cryptBufBlock.get(j) ^ prevPlainTeaBufBlock.get(j)));
        }
        Crypt.teaDecryptECB(cryptTeaBufBlock, key, plainTeaBufBlock);
        for (j = 0; j < 8; ++j) {
            plainBufBlock.put(j, (byte)(plainTeaBufBlock.get(j) ^ prevCryptBufBlock.get(j)));
        }
        for (j = 0; j < 8; ++j) {
            prevPlainTeaBufBlock.put(j, plainTeaBufBlock.get(j));
            prevCryptBufBlock.put(j, cryptBufBlock.get(j));
        }
    }

    private static void teaDecryptECB(ByteBuffer inBuf, ByteBuffer key, ByteBuffer outBuf) {
        long y = (long)inBuf.getInt(0) & 0xFFFFFFFFL;
        long z = (long)inBuf.getInt(4) & 0xFFFFFFFFL;
        long[] k = new long[4];
        for (int i = 0; i < 4; ++i) {
            k[i] = key.getInt(i * 4);
        }
        long sum = 3816266640L;
        for (int i = 0; i < 16; ++i) {
            z = z - ((y << 4) + k[2] ^ y + sum ^ (y >> 5) + k[3]) & 0xFFFFFFFFL;
            y = y - ((z << 4) + k[0] ^ z + sum ^ (z >> 5) + k[1]) & 0xFFFFFFFFL;
            sum = sum - 2654435769L & 0xFFFFFFFFL;
        }
        outBuf.putInt(0, (int)y);
        outBuf.putInt(4, (int)z);
    }

    public static byte[] hexToBytes(String s) {
        s = s.toUpperCase();
        int len = s.length() / 2;
        int ii = 0;
        byte[] bs = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c;
            int h = (c = s.charAt(ii++)) <= '9' ? c - 48 : c - 65 + 10;
            h <<= 4;
            h = (c = s.charAt(ii++)) <= '9' ? (h |= c - 48) : (h |= c - 65 + 10);
            bs[i] = (byte)h;
        }
        return bs;
    }

    public static final String bytesToHexString(byte[] bArray) {
        StringBuilder sb = new StringBuilder(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static int getSdkappid() {
        return sdkappid;
    }

    public static void setSdkappid(int sdkappid) {
        Crypt.sdkappid = sdkappid;
    }

    public static String getKey() {
        return key;
    }

    public static void setKey(String key) {
        Crypt.key = key;
    }

    static {
        RANDOM = new Random();
        baiqiLogisticsLocalCache = CacheBuilder.newBuilder().maximumSize(5L).expireAfterWrite(60L, TimeUnit.MINUTES).build();
    }
}

