/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.common.tool;

import cn.com.wawa.common.tool.HttpClientUtil;
import cn.com.wawa.common.tool.IpUtil;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdbLib {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdbLib.class);
    private String dbhost;
    private String appkey;
    private String appscret;
    private String token;
    private String serviceUrl;

    public Map<String, String> edbGetCommonParams(String method) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("method", method);
        map.put("dbhost", this.dbhost);
        map.put("appkey", this.appkey);
        map.put("format", "JSON");
        map.put("timestamp", new SimpleDateFormat("yyyyMMddHHmm").format(new Date()));
        map.put("v", "2.0");
        map.put("slencry", "1");
        map.put("ip", IpUtil.getIp());
        return map;
    }

    public String edbRequstPost(Map<String, String> params) {
        params.put("sign", this.edbSignature(params));
        return HttpClientUtil.sendPost(this.serviceUrl, params);
    }

    private String edbSignature(Map<String, String> params) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>((o1, o2) -> o1.compareToIgnoreCase((String)o2));
        treeMap.putAll(params);
        treeMap.put("appscret", this.appscret);
        treeMap.put("token", this.token);
        StringBuilder builder = new StringBuilder(this.appkey);
        for (String key : treeMap.keySet()) {
            if ("".equals(key) || "".equals(treeMap.get(key))) continue;
            builder.append(key).append((String)treeMap.get(key));
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(builder.toString().getBytes("utf-8"));
            builder.setLength(0);
            for (byte b : bytes) {
                String hx = Integer.toHexString(b & 0xFF);
                builder.append(hx.length() == 1 ? "0" + hx : hx);
            }
            return builder.toString().toUpperCase();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return "\u7b7e\u540d\u5f02\u5e38";
        }
    }

    public static Logger getLOGGER() {
        return LOGGER;
    }

    public String getDbhost() {
        return this.dbhost;
    }

    public void setDbhost(String dbhost) {
        this.dbhost = dbhost;
    }

    public String getAppkey() {
        return this.appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getAppscret() {
        return this.appscret;
    }

    public void setAppscret(String appscret) {
        this.appscret = appscret;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }
}

