/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.common.tool;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpUtil.class);
    private static final String ANYHOST = "0.0.0.0";
    private static final String LOCALHOST = "127.0.0.1";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static volatile InetAddress localAddress = null;

    private IpUtil() {
    }

    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && !LOCALHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    private static InetAddress getFirstValidAddress() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (IpUtil.isValidAddress(localAddress)) {
                return localAddress;
            }
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces == null) {
                return localAddress;
            }
            while (interfaces.hasMoreElements()) {
                NetworkInterface network = interfaces.nextElement();
                Enumeration<InetAddress> addresses = network.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!IpUtil.isValidAddress(address)) continue;
                    return address;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to retriving ip address", (Throwable)e);
        }
        LOGGER.warn("Could not get local host ip address, will use 127.0.0.1 instead.");
        return localAddress;
    }

    private static InetAddress getAddress() {
        if (localAddress != null) {
            return localAddress;
        }
        localAddress = IpUtil.getFirstValidAddress();
        if (localAddress != null) {
            LOGGER.info("\u672c\u673a\u5916\u7f51IP={}", (Object)localAddress.getHostAddress());
        }
        return localAddress;
    }

    public static String getIp() {
        InetAddress address = IpUtil.getAddress();
        if (address == null) {
            return LOCALHOST;
        }
        return address.getHostAddress();
    }
}

