/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.common.tool;

import cn.com.wawa.common.exception.MD5InstException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5 {
    private static final Logger LOG = LoggerFactory.getLogger(MD5.class);
    private static String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private static MessageDigest mdInst = null;
    private static char[] hexDigitsEncode = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private MD5() {
    }

    private static MessageDigest getMdInst() {
        if (mdInst == null) {
            try {
                mdInst = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new MD5InstException(e);
            }
        }
        return mdInst;
    }

    public static String md5(byte[] b) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(b, 0, b.length);
        return MD5.byteArrayToHexString(md5.digest());
    }

    public static String md5(String data) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte[] b = data.getBytes("UTF8");
            md5.update(b, 0, b.length);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            LOG.error("MD5\u52a0\u5bc6\u5931\u8d25, data=" + data, (Throwable)e);
            return null;
        }
        return MD5.byteArrayToHexString(md5.digest());
    }

    public static final String encode(String s) {
        try {
            byte[] btInput = s.getBytes();
            MD5.getMdInst().update(btInput);
            byte[] md = MD5.getMdInst().digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigitsEncode[byte0 >>> 4 & 0xF];
                str[k++] = hexDigitsEncode[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            LOG.warn("\u7f16\u7801\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(MD5.byteToHexString(b[i]));
        }
        return sb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }
}

