/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.common.tool;

import cn.com.wawa.common.bean.ValueRateBean;
import cn.com.wawa.common.exception.RandomRateErrorException;
import cn.com.wawa.common.tool.RandomUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RateUtil {
    private RateUtil() {
    }

    public static int randomRateIndex(List<Integer> rates) {
        try {
            int totalRate = 0;
            for (Integer rate : rates) {
                totalRate += rate.intValue();
            }
            int random = RandomUtils.random(totalRate, 1);
            int lestRate = totalRate;
            int index = 0;
            for (Integer rate : rates) {
                if ((lestRate -= rate.intValue()) < random) {
                    return index;
                }
                ++index;
            }
        }
        catch (Exception e) {
            throw new RandomRateErrorException(e);
        }
        throw new RandomRateErrorException("\u6839\u636e\u6743\u91cd\u751f\u6210\u968f\u673a\u6570\u5931\u8d25");
    }

    public static <T> T randomRateValue(List<ValueRateBean<T>> valueRates) {
        try {
            int totalRate = 0;
            ArrayList<Integer> rates = new ArrayList<Integer>(valueRates.size());
            HashMap<Integer, T> indexValueMap = new HashMap<Integer, T>(valueRates.size());
            int index = 0;
            for (ValueRateBean<T> valueRateBean : valueRates) {
                Integer rate = valueRateBean.getRate();
                T value = valueRateBean.getValue();
                totalRate += rate.intValue();
                rates.add(rate);
                indexValueMap.put(index, value);
                ++index;
            }
            int random = RandomUtils.random(totalRate, 1);
            int lestRate = totalRate;
            index = 0;
            for (Integer rate : rates) {
                if ((lestRate -= rate.intValue()) < random) {
                    return (T)indexValueMap.get(index);
                }
                ++index;
            }
        }
        catch (Exception e) {
            throw new RandomRateErrorException(e);
        }
        throw new RandomRateErrorException("\u6839\u636e\u6743\u91cd\u751f\u6210\u968f\u673a\u6570\u5931\u8d25");
    }
}

