/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.common.tool;

import cn.com.wawa.common.exception.RetryFailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetryFragment<T> {
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final int DEFAULT_RETRY_INTERVAL_MS = 200;
    private int retryCount = 3;
    private int intervalMs = 200;
    private Logger logger = LoggerFactory.getLogger(cn.com.wawa.proxy.api.bean.RetryFragment.class);

    public RetryFragment() {
    }

    public RetryFragment(int retryCount, int intervalMs) {
        this.retryCount = retryCount;
        this.intervalMs = intervalMs;
    }

    protected abstract T codeFragment();

    public T invoke() throws RetryFailException {
        return this.invoke(0);
    }

    private T invoke(int initTimes) throws RetryFailException {
        T t = null;
        Exception lastException = null;
        boolean validResult = false;
        for (int i = initTimes; i < this.retryCount; ++i) {
            try {
                t = this.codeFragment();
                validResult = this.validValue(t);
                if (validResult) {
                    break;
                }
            }
            catch (Exception ex) {
                lastException = ex;
                this.logger.error("retry_fragment execution times:{}, exception:{}", (Object)i, (Object)ex.getMessage());
            }
            if (this.intervalMs == 0) continue;
            this.sleep(this.intervalMs);
        }
        if (validResult) {
            return t;
        }
        if (lastException != null && t == null) {
            throw new RetryFailException("\u91cd\u8bd5\u5f02\u5e38", lastException);
        }
        return t;
    }

    protected boolean validValue(T t) {
        return true;
    }

    private void sleep(int sleepMs) {
        if (sleepMs <= 0) {
            return;
        }
        try {
            Thread.sleep(sleepMs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

