/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.common.tool;

import cn.com.duiba.wolf.utils.NumberUtils;
import cn.com.wawa.common.exception.GetSigFailException;
import com.tls.base64_url.base64_url;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.Arrays;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsSigature {
    private static final Logger LOG = LoggerFactory.getLogger(TlsSigature.class);
    public static final String TLS_APPID_AT_3RD = "TLS.appid_at_3rd";
    public static final String TLS_ACCOUNT_TYPE = "TLS.account_type";
    public static final String TLS_IDENTIFIER = "TLS.identifier";
    public static final String TLS_SDK_APPID = "TLS.sdk_appid";
    public static final String TLS_TIME = "TLS.time";
    public static final String TLS_EXPIRE_AFTER = "TLS.expire_after";
    public static final String SHA_256_WITH_ECDSA = "SHA256withECDSA";
    public static final String TLS_SIG = "TLS.sig";
    public static final String COLON = ":";
    public static final String NEW_LINE = "\n";
    private static String authKey;
    private static String appId;
    private static String privateKey;

    private TlsSigature() {
    }

    public static String getSig(String userId) {
        String privStr = privateKey;
        try {
            GenTLSSignatureResult result = TlsSigature.genTLSSignatureEx(NumberUtils.parseInt((String)appId, (int)0), String.valueOf(userId), privStr);
            if (0 == result.urlSig.length()) {
                LOG.error(String.format("GenTLSSignatureEx failed:{0}", result.errMessage));
                throw new GetSigFailException();
            }
            return result.urlSig;
        }
        catch (IOException e) {
            LOG.error(String.format("GenTLSSignatureEx failed:{0}", e.getMessage()), (Throwable)e);
            throw new GetSigFailException(e);
        }
    }

    @Deprecated
    public static GenTLSSignatureResult genTLSSignature(long expire, String strAppid3rd, long skdAppid, String identifier, long accountType, String privStr) throws IOException {
        GenTLSSignatureResult result = new GenTLSSignatureResult();
        Security.addProvider((Provider)new BouncyCastleProvider());
        CharArrayReader reader = new CharArrayReader(privStr.toCharArray());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        PEMParser parser = new PEMParser((Reader)reader);
        Object obj = parser.readObject();
        parser.close();
        PrivateKey privKeyStruct = converter.getPrivateKey((PrivateKeyInfo)obj);
        String jsonString = "{\"TLS.account_type\":\"" + accountType + "\",\"TLS.identifier\":\"" + identifier + "\",\"TLS.appid_at_3rd\":\"" + strAppid3rd + "\",\"TLS.sdk_appid\":\"" + skdAppid + "\",\"TLS.expire_after\":\"" + expire + "\"}";
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String serialString = TLS_APPID_AT_3RD + COLON + strAppid3rd + NEW_LINE + TLS_ACCOUNT_TYPE + COLON + accountType + NEW_LINE + TLS_IDENTIFIER + COLON + identifier + NEW_LINE + TLS_SDK_APPID + COLON + skdAppid + NEW_LINE + TLS_TIME + COLON + time + NEW_LINE + TLS_EXPIRE_AFTER + COLON + expire + NEW_LINE;
        try {
            Signature signature = Signature.getInstance(SHA_256_WITH_ECDSA, "BC");
            signature.initSign(privKeyStruct);
            signature.update(serialString.getBytes(Charset.forName("UTF-8")));
            byte[] signatureBytes = signature.sign();
            String sigTLS = Base64.encodeBase64String((byte[])signatureBytes);
            JSONObject jsonObject = new JSONObject(jsonString);
            jsonObject.put(TLS_SIG, (Object)sigTLS);
            jsonObject.put(TLS_TIME, (Object)time);
            jsonString = jsonObject.toString();
            Deflater compresser = new Deflater();
            compresser.setInput(jsonString.getBytes(Charset.forName("UTF-8")));
            compresser.finish();
            byte[] compressBytes = new byte[512];
            int compressBytesLength = compresser.deflate(compressBytes);
            compresser.end();
            String userSig = new String(base64_url.base64EncodeUrl((byte[])Arrays.copyOfRange((byte[])compressBytes, (int)0, (int)compressBytesLength)));
            result.urlSig = userSig;
        }
        catch (Exception e) {
            result.errMessage = "generate usersig failed";
            LOG.warn(result.errMessage, (Throwable)e);
        }
        return result;
    }

    @Deprecated
    public static CheckTLSSignatureResult checkTLSSignature(String urlSig, String strAppid3rd, long skdAppid, String identifier, long accountType, String publicKey) throws DataFormatException {
        CheckTLSSignatureResult result = new CheckTLSSignatureResult();
        Security.addProvider((Provider)new BouncyCastleProvider());
        Base64 decoder = new Base64();
        byte[] compressBytes = base64_url.base64DecodeUrl((byte[])urlSig.getBytes(Charset.forName("UTF-8")));
        Inflater decompression = new Inflater();
        decompression.setInput(compressBytes, 0, compressBytes.length);
        byte[] decompressBytes = new byte[1024];
        int decompressLength = decompression.inflate(decompressBytes);
        decompression.end();
        String jsonString = new String(Arrays.copyOfRange((byte[])decompressBytes, (int)0, (int)decompressLength));
        JSONObject jsonObject = new JSONObject(jsonString);
        String sigTLS = jsonObject.getString(TLS_SIG);
        byte[] signatureBytes = decoder.decode(sigTLS.getBytes(Charset.forName("UTF-8")));
        try {
            String sigTime = jsonObject.getString(TLS_TIME);
            String sigExpire = jsonObject.getString(TLS_EXPIRE_AFTER);
            if (System.currentTimeMillis() / 1000L - Long.parseLong(sigTime) > Long.parseLong(sigExpire)) {
                result.errMessage = "TLS sig is out of date ";
                return result;
            }
            String serialString = TLS_APPID_AT_3RD + COLON + strAppid3rd + NEW_LINE + TLS_ACCOUNT_TYPE + COLON + accountType + NEW_LINE + TLS_IDENTIFIER + COLON + identifier + NEW_LINE + TLS_SDK_APPID + COLON + skdAppid + NEW_LINE + TLS_TIME + COLON + sigTime + NEW_LINE + TLS_EXPIRE_AFTER + COLON + sigExpire + NEW_LINE;
            CharArrayReader reader = new CharArrayReader(publicKey.toCharArray());
            PEMParser parser = new PEMParser((Reader)reader);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            Object obj = parser.readObject();
            parser.close();
            PublicKey pubKeyStruct = converter.getPublicKey((SubjectPublicKeyInfo)obj);
            Signature signature = Signature.getInstance(SHA_256_WITH_ECDSA, "BC");
            signature.initVerify(pubKeyStruct);
            signature.update(serialString.getBytes(Charset.forName("UTF-8")));
            boolean bool = signature.verify(signatureBytes);
            result.verifyResult = bool;
        }
        catch (Exception e) {
            result.errMessage = "Failed in checking sig";
            LOG.warn(result.errMessage, (Throwable)e);
        }
        return result;
    }

    public static GenTLSSignatureResult genTLSSignatureEx(long skdAppid, String identifier, String privStr) throws IOException {
        return TlsSigature.genTLSSignatureEx(skdAppid, identifier, privStr, 15552000L);
    }

    public static GenTLSSignatureResult genTLSSignatureEx(long skdAppid, String identifier, String privStr, long expire) throws IOException {
        GenTLSSignatureResult result = new GenTLSSignatureResult();
        Security.addProvider((Provider)new BouncyCastleProvider());
        CharArrayReader reader = new CharArrayReader(privStr.toCharArray());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        PEMParser parser = new PEMParser((Reader)reader);
        Object obj = parser.readObject();
        parser.close();
        PrivateKey privKeyStruct = converter.getPrivateKey((PrivateKeyInfo)obj);
        String jsonString = "{\"TLS.account_type\":\"0\",\"TLS.identifier\":\"" + identifier + "\",\"TLS.appid_at_3rd\":\"" + 0 + "\",\"TLS.sdk_appid\":\"" + skdAppid + "\",\"TLS.expire_after\":\"" + expire + "\",\"TLS.version\": \"201512300000\"}";
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String serialString = TLS_APPID_AT_3RD + COLON + 0 + NEW_LINE + TLS_ACCOUNT_TYPE + COLON + 0 + NEW_LINE + TLS_IDENTIFIER + COLON + identifier + NEW_LINE + TLS_SDK_APPID + COLON + skdAppid + NEW_LINE + TLS_TIME + COLON + time + NEW_LINE + TLS_EXPIRE_AFTER + COLON + expire + NEW_LINE;
        try {
            Signature signature = Signature.getInstance(SHA_256_WITH_ECDSA, "BC");
            signature.initSign(privKeyStruct);
            signature.update(serialString.getBytes(Charset.forName("UTF-8")));
            byte[] signatureBytes = signature.sign();
            String sigTLS = Base64.encodeBase64String((byte[])signatureBytes);
            JSONObject jsonObject = new JSONObject(jsonString);
            jsonObject.put(TLS_SIG, (Object)sigTLS);
            jsonObject.put(TLS_TIME, (Object)time);
            jsonString = jsonObject.toString();
            Deflater compresser = new Deflater();
            compresser.setInput(jsonString.getBytes(Charset.forName("UTF-8")));
            compresser.finish();
            byte[] compressBytes = new byte[512];
            int compressBytesLength = compresser.deflate(compressBytes);
            compresser.end();
            String userSig = new String(base64_url.base64EncodeUrl((byte[])Arrays.copyOfRange((byte[])compressBytes, (int)0, (int)compressBytesLength)));
            result.urlSig = userSig;
        }
        catch (Exception e) {
            result.errMessage = "generate usersig failed";
            LOG.warn(result.errMessage, (Throwable)e);
        }
        return result;
    }

    public static CheckTLSSignatureResult checkTLSSignatureEx(String urlSig, long sdkAppid, String identifier, String publicKey) throws DataFormatException {
        CheckTLSSignatureResult result = new CheckTLSSignatureResult();
        Security.addProvider((Provider)new BouncyCastleProvider());
        Base64 decoder = new Base64();
        byte[] compressBytes = base64_url.base64DecodeUrl((byte[])urlSig.getBytes(Charset.forName("UTF-8")));
        Inflater decompression = new Inflater();
        decompression.setInput(compressBytes, 0, compressBytes.length);
        byte[] decompressBytes = new byte[1024];
        int decompressLength = decompression.inflate(decompressBytes);
        decompression.end();
        String jsonString = new String(Arrays.copyOfRange((byte[])decompressBytes, (int)0, (int)decompressLength));
        JSONObject jsonObject = new JSONObject(jsonString);
        String sigTLS = jsonObject.getString(TLS_SIG);
        byte[] signatureBytes = decoder.decode(sigTLS.getBytes(Charset.forName("UTF-8")));
        try {
            String strSdkAppid = jsonObject.getString(TLS_SDK_APPID);
            String sigTime = jsonObject.getString(TLS_TIME);
            String sigExpire = jsonObject.getString(TLS_EXPIRE_AFTER);
            if ((long)Integer.parseInt(strSdkAppid) != sdkAppid) {
                result.errMessage = "sdkappid " + strSdkAppid + " in tls sig not equal sdkappid " + sdkAppid + " in request";
                return result;
            }
            if (System.currentTimeMillis() / 1000L - Long.parseLong(sigTime) > Long.parseLong(sigExpire)) {
                result.errMessage = "TLS sig is out of date";
                return result;
            }
            String serialString = TLS_APPID_AT_3RD + COLON + 0 + NEW_LINE + TLS_ACCOUNT_TYPE + COLON + 0 + NEW_LINE + TLS_IDENTIFIER + COLON + identifier + NEW_LINE + TLS_SDK_APPID + COLON + sdkAppid + NEW_LINE + TLS_TIME + COLON + sigTime + NEW_LINE + TLS_EXPIRE_AFTER + COLON + sigExpire + NEW_LINE;
            CharArrayReader reader = new CharArrayReader(publicKey.toCharArray());
            PEMParser parser = new PEMParser((Reader)reader);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            Object obj = parser.readObject();
            parser.close();
            PublicKey pubKeyStruct = converter.getPublicKey((SubjectPublicKeyInfo)obj);
            Signature signature = Signature.getInstance(SHA_256_WITH_ECDSA, "BC");
            signature.initVerify(pubKeyStruct);
            signature.update(serialString.getBytes(Charset.forName("UTF-8")));
            boolean bool = signature.verify(signatureBytes);
            result.expireTime = Integer.parseInt(sigExpire);
            result.initTime = Integer.parseInt(sigTime);
            result.verifyResult = bool;
        }
        catch (Exception e) {
            result.errMessage = "Failed in checking sig";
            LOG.warn(result.errMessage, (Throwable)e);
        }
        return result;
    }

    public static String getAuthKey() {
        return authKey;
    }

    public static void setAuthKey(String authKey) {
        TlsSigature.authKey = authKey;
    }

    public static String getAppId() {
        return appId;
    }

    public static void setAppId(String appId) {
        TlsSigature.appId = appId;
    }

    public static String getPrivateKey() {
        return privateKey;
    }

    public static void setPrivateKey(String privateKey) {
        TlsSigature.privateKey = privateKey;
    }

    public static class CheckTLSSignatureResult {
        private String errMessage = "";
        private boolean verifyResult = false;
        private int expireTime;
        private int initTime;

        public boolean isVerifyResult() {
            return this.verifyResult;
        }

        public void setVerifyResult(boolean verifyResult) {
            this.verifyResult = verifyResult;
        }

        public int getExpireTime() {
            return this.expireTime;
        }

        public void setExpireTime(int expireTime) {
            this.expireTime = expireTime;
        }

        public int getInitTime() {
            return this.initTime;
        }

        public void setInitTime(int initTime) {
            this.initTime = initTime;
        }

        public String getErrMessage() {
            return this.errMessage;
        }

        public void setErrMessage(String errMessage) {
            this.errMessage = errMessage;
        }
    }

    public static class GenTLSSignatureResult {
        private String errMessage = "";
        private String urlSig = "";
    }
}

