package cn.com.wawa.common.tool;

import com.alibaba.fastjson.JSONObject;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

/**
 * 请求响应结果，支持jsonp响应
 *
 * <p>固定参数：success标明请求处理结果，message响应附加信息（主要用于处理失败时的信息提示）
 * callback保存回调函数名称,在jsonp请求时非空</p>
 *
 * @author xiaoxuda 16/11/22
 * @author liuyao 16/11/24
 */
public class JsonRender extends JSONObject {
    /**
	 * 
	 */
	private static final long serialVersionUID = -466686765952338133L;

//	private static final Logger log = LoggerFactory.getLogger(JsonRender.class);

    private static final  String SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String CALLBACK = "callback";
    private static final String DATA="data";

    private JsonRender(){}

    /**
     *
     * @return
     */
    public static JsonRender successResult(){
        JsonRender resp = new JsonRender();
        resp.put(SUCCESS,true);
        resp.put(DATA,new HashMap<String,Object>());
        return resp;
    }

    /**
     *
     * @param model
     * @return
     */
    public static JsonRender successResult(JSONObject model){
        JsonRender resp=successResult();
        ((Map)resp.get(DATA)).putAll(model);
        return resp;
    }

    /**
     *
     * @param params
     * @return
     */
    public  JsonRender addALL(Map<String,Object> params){
        JsonRender resp=successResult();
        ((Map)resp.get(DATA)).putAll(params);
        return resp;
    }

    /**
     *
     * @param message
     * @return
     */
    public static JsonRender failResult(String message){
        JsonRender resp = new JsonRender();
        resp.put(JsonRender.SUCCESS,false);
        resp.put(JsonRender.MESSAGE,message);
        return resp;
    }

    /**
     *
     * @param e
     * @return
     */
    public static JsonRender failResult(Throwable e){
        JsonRender resp = new JsonRender();
        resp.put(JsonRender.SUCCESS,false);
        resp.put(JsonRender.MESSAGE,e.getMessage());
        return resp;
    }


    /**
     * jsonp响应时传入回调函数名称
     * @param callback
     * @return
     */
    public JsonRender setJSONPCallback(String callback){
        this.put(JsonRender.CALLBACK,callback);
        return this;
    }

    /**
     * 请求处理结果
     * @return
     */
    public boolean isSuccess() {
        return this.getBoolean(JsonRender.SUCCESS);
    }

    /**
     * 获取失败信息
     * @return
     */
    public String getMessage(){
        return this.getString(MESSAGE);
    }

    /**
     * 设置响应提示信息
     * @param message
     */
    public JsonRender setMessage(String message){
        this.put(JsonRender.MESSAGE,message);
        return this;
    }

    /**
     * 写入返回值
     * @param key
     * @param result
     * @return
     */
    public JsonRender addResult(String key,Object result){
        ((Map)this.get(DATA)).put(key,result);
        return this;
    }

    /**
     * jsonp处理
     * @param response
     * @param callback
     */
    public void forJsonpReturn(HttpServletResponse response, String callback){
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.write(callback + "(" + this.toJSONString() + ")");
        }catch(IOException e){
           // log.error("e={}",e);
        }finally {
            if(out!=null) out.close();
        }
    }
}
