package cn.com.wawa.common.tool;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class WeixinLoginTool {

    public static final String WEIXIN_ACCESS_TOKEN ="weixinAccessToken";
    public static final String WEIXIN_OPENID ="openid";
    public static final String WEIXIN_NICKNAME="nickname";
    public static final String WEIXIN_SEX="sex";
    public static final String WEIXIN_PROVINCE="province";
    public static final String WEIXIN_CITY="city";
    public static final String WEIXIN_COUNTRY="country";
    public static final String WEIXIN_HEAD_IMGURL="headimgurl";

    private static final String ANDRIOD_APPID="wx5afb8bbbdcf6f868";
    private static final String IOS_APPID = "wx78f26efb2fd412bd";

    private static final String IOS_SECRET = "944e376ddfbd0eabf12756a3b3272d92";
    private static final String ANDRIOD_SECRET ="fddcb657c761a60a610241e2d791437c";

    public static void main(String[] args) {
        System.out.println(RandomStringUtils.random(32,true,true));
    }

    public static Map<String, Object> getToken(String code,int type) throws Exception {
        StringBuilder buff = new StringBuilder(128);
        buff.append("https://api.weixin.qq.com/sns/oauth2/access_token?appid=");
        buff.append(getAppId(type));
        buff.append("&secret=");
        buff.append(getSecret(type));
        buff.append("&grant_type=authorization_code&code=");
        buff.append(code);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(buff.toString());
        get.setConfig(getTimeoutConfig());
        CloseableHttpResponse response = client.execute(get);
        String body;
        try {
            body = EntityUtils.toString(response.getEntity(), "utf-8");
            System.out.println(body);
        } finally {
            response.close();
        }
        if (StringUtils.isNotBlank(body)) {
            JSONObject jsonObject = JSONObject.parseObject(body);
            String accessToken = jsonObject.getString("access_token");
            String openid = jsonObject.getString("openid");
            if (StringUtils.isNotBlank(accessToken) && StringUtils.isNotBlank(openid)) {
                Map<String, Object> map = new HashMap<>();
                map.put(WEIXIN_ACCESS_TOKEN, accessToken);
                map.put("openid", openid);
                return map;
            }
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> getWeixinUserInfo(String openId, String accessToken,Integer type) throws Exception {
        if (StringUtils.isBlank(openId) || StringUtils.isBlank(accessToken)) {
            return Collections.emptyMap();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/sns/userinfo?access_token=");
        builder.append(accessToken);
        builder.append("&openid=");
        builder.append(openId);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(builder.toString());
        get.setConfig(getTimeoutConfig());
        CloseableHttpResponse response = client.execute(get);
        String body;
        try {
            body = EntityUtils.toString(response.getEntity(), "utf-8");
        } finally {
            response.close();
        }
        if (StringUtils.isNotBlank(body)) {
            JSONObject jsonObject = JSONObject.parseObject(body);
            if (jsonObject.containsKey(WEIXIN_OPENID)) {
                return jsonObject;
            }
        }
        return Collections.emptyMap();
    }

    private static String getAppId(int type){
        if(1==type){
            return ANDRIOD_APPID;
        }
        return ANDRIOD_APPID;
    }

    private static String getSecret(int type){
        if(1==type) {
            return ANDRIOD_SECRET;
        }
        return ANDRIOD_SECRET;
    }


    private static RequestConfig getTimeoutConfig() {
        return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
    }
}
