/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.BytesResource;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.MultiFileResource;
import cn.hutool.core.io.resource.MultiResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.GlobalHeaders;
import cn.hutool.http.Header;
import cn.hutool.http.HttpBase;
import cn.hutool.http.HttpConnection;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import cn.hutool.http.cookie.GlobalCookieManager;
import cn.hutool.http.ssl.SSLSocketFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.Proxy;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class HttpRequest
extends HttpBase<HttpRequest> {
    private static final String BOUNDARY = "--------------------Hutool_" + RandomUtil.randomString(16);
    private static final byte[] BOUNDARY_END = StrUtil.format((CharSequence)"--{}--\r\n", BOUNDARY).getBytes();
    private static final String CONTENT_DISPOSITION_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"\r\n\r\n";
    private static final String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"; filename=\"{}\"\r\n";
    private static final String CONTENT_TYPE_MULTIPART_PREFIX = "multipart/form-data; boundary=";
    private static final String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type: {}\r\n\r\n";
    private String url;
    private URLStreamHandler urlHandler;
    private Method method = Method.GET;
    private int connectionTimeout = HttpGlobalConfig.timeout;
    private int readTimeout = HttpGlobalConfig.timeout;
    private Map<String, Object> form;
    private Map<String, Resource> fileForm;
    private String cookie;
    private HttpConnection httpConnection;
    private boolean isDisableCache;
    private boolean encodeUrlParams;
    private boolean isRest;
    private int redirectCount;
    private int maxRedirectCount;
    private int blockSize;
    private Proxy proxy;
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory ssf;

    public static void setGlobalTimeout(int customTimeout) {
        HttpGlobalConfig.setTimeout(customTimeout);
    }

    public static CookieManager getCookieManager() {
        return GlobalCookieManager.getCookieManager();
    }

    public static void setCookieManager(CookieManager customCookieManager) {
        GlobalCookieManager.setCookieManager(customCookieManager);
    }

    public static void closeCookie() {
        GlobalCookieManager.setCookieManager(null);
    }

    public HttpRequest(String url) {
        Assert.notBlank(url, "Param [url] can not be blank !", new Object[0]);
        this.url = URLUtil.normalize(url, true);
        this.header(GlobalHeaders.INSTANCE.headers);
    }

    public static HttpRequest post(String url) {
        return new HttpRequest(url).method(Method.POST);
    }

    public static HttpRequest get(String url) {
        return new HttpRequest(url).method(Method.GET);
    }

    public static HttpRequest head(String url) {
        return new HttpRequest(url).method(Method.HEAD);
    }

    public static HttpRequest options(String url) {
        return new HttpRequest(url).method(Method.OPTIONS);
    }

    public static HttpRequest put(String url) {
        return new HttpRequest(url).method(Method.PUT);
    }

    public static HttpRequest patch(String url) {
        return new HttpRequest(url).method(Method.PATCH);
    }

    public static HttpRequest delete(String url) {
        return new HttpRequest(url).method(Method.DELETE);
    }

    public static HttpRequest trace(String url) {
        return new HttpRequest(url).method(Method.TRACE);
    }

    public String getUrl() {
        return this.url;
    }

    public HttpRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public HttpRequest setUrlHandler(URLStreamHandler urlHandler) {
        this.urlHandler = urlHandler;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpRequest setMethod(Method method) {
        return this.method(method);
    }

    public HttpConnection getConnection() {
        return this.httpConnection;
    }

    public HttpRequest method(Method method) {
        this.method = method;
        return this;
    }

    public HttpRequest contentType(String contentType) {
        this.header(Header.CONTENT_TYPE, contentType);
        return this;
    }

    public HttpRequest keepAlive(boolean isKeepAlive) {
        this.header(Header.CONNECTION, isKeepAlive ? "Keep-Alive" : "Close");
        return this;
    }

    public boolean isKeepAlive() {
        String connection = this.header(Header.CONNECTION);
        if (connection == null) {
            return !this.httpVersion.equalsIgnoreCase("HTTP/1.0");
        }
        return false == "close".equalsIgnoreCase(connection);
    }

    public String contentLength() {
        return this.header(Header.CONTENT_LENGTH);
    }

    public HttpRequest contentLength(int value) {
        this.header(Header.CONTENT_LENGTH, String.valueOf(value));
        return this;
    }

    public HttpRequest cookie(HttpCookie ... cookies) {
        if (ArrayUtil.isEmpty(cookies)) {
            return this.disableCookie();
        }
        return this.cookie(ArrayUtil.join(cookies, (CharSequence)";"));
    }

    public HttpRequest cookie(String cookie) {
        this.cookie = cookie;
        return this;
    }

    public HttpRequest disableCookie() {
        return this.cookie("");
    }

    public HttpRequest enableDefaultCookie() {
        return this.cookie((String)null);
    }

    public HttpRequest form(String name, Object value) {
        String strValue;
        if (StrUtil.isBlank(name) || ObjectUtil.isNull(value)) {
            return this;
        }
        this.bodyBytes = null;
        if (value instanceof File) {
            return this.form(name, (File)value);
        }
        if (value instanceof Resource) {
            return this.form(name, (Resource)value);
        }
        if (this.form == null) {
            this.form = new LinkedHashMap<String, Object>();
        }
        if (value instanceof List) {
            strValue = CollectionUtil.join((List)value, (CharSequence)",");
        } else if (ArrayUtil.isArray(value)) {
            if (File.class == ArrayUtil.getComponentType(value)) {
                return this.form(name, (File[])value);
            }
            strValue = ArrayUtil.join((Object[])value, (CharSequence)",");
        } else {
            strValue = Convert.toStr(value, null);
        }
        this.form.put(name, strValue);
        return this;
    }

    public HttpRequest form(String name, Object value, Object ... parameters) {
        this.form(name, value);
        for (int i = 0; i < parameters.length; i += 2) {
            name = parameters[i].toString();
            this.form(name, parameters[i + 1]);
        }
        return this;
    }

    public HttpRequest form(Map<String, Object> formMap) {
        if (MapUtil.isNotEmpty(formMap)) {
            for (Map.Entry<String, Object> entry : formMap.entrySet()) {
                this.form(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public HttpRequest form(String name, File ... files) {
        if (1 == files.length) {
            File file = files[0];
            return this.form(name, file, file.getName());
        }
        return this.form(name, new MultiFileResource(files));
    }

    public HttpRequest form(String name, File file) {
        return this.form(name, file, file.getName());
    }

    public HttpRequest form(String name, File file, String fileName) {
        if (null != file) {
            this.form(name, new FileResource(file, fileName));
        }
        return this;
    }

    public HttpRequest form(String name, byte[] fileBytes, String fileName) {
        if (null != fileBytes) {
            this.form(name, new BytesResource(fileBytes, fileName));
        }
        return this;
    }

    public HttpRequest form(String name, Resource resource) {
        if (null != resource) {
            if (!this.isKeepAlive()) {
                this.keepAlive(true);
            }
            if (null == this.fileForm) {
                this.fileForm = new HashMap<String, Resource>();
            }
            this.fileForm.put(name, resource);
        }
        return this;
    }

    public Map<String, Object> form() {
        return this.form;
    }

    public Map<String, Resource> fileForm() {
        return this.fileForm;
    }

    public HttpRequest body(String body) {
        return this.body(body, null);
    }

    public HttpRequest body(String body, String contentType) {
        byte[] bytes = StrUtil.bytes((CharSequence)body, this.charset);
        this.body(bytes);
        this.form = null;
        this.contentLength(bytes.length);
        if (null != contentType) {
            this.contentType(contentType);
        } else {
            contentType = HttpUtil.getContentTypeByRequestBody(body);
            if (null != contentType && ContentType.isDefault(this.header(Header.CONTENT_TYPE))) {
                if (null != this.charset) {
                    contentType = ContentType.build(contentType, this.charset);
                }
                this.contentType(contentType);
            }
        }
        if (StrUtil.containsAnyIgnoreCase(contentType, "json", "xml")) {
            this.isRest = true;
        }
        return this;
    }

    public HttpRequest body(byte[] bodyBytes) {
        if (null != bodyBytes) {
            this.bodyBytes = bodyBytes;
        }
        return this;
    }

    public HttpRequest timeout(int milliseconds) {
        this.setConnectionTimeout(milliseconds);
        this.setReadTimeout(milliseconds);
        return this;
    }

    public HttpRequest setConnectionTimeout(int milliseconds) {
        this.connectionTimeout = milliseconds;
        return this;
    }

    public HttpRequest setReadTimeout(int milliseconds) {
        this.readTimeout = milliseconds;
        return this;
    }

    public HttpRequest disableCache() {
        this.isDisableCache = true;
        return this;
    }

    public HttpRequest setEncodeUrlParams(boolean isEncodeUrlParams) {
        this.encodeUrlParams = isEncodeUrlParams;
        return this;
    }

    public HttpRequest setFollowRedirects(boolean isFollowRedirects) {
        return this.setMaxRedirectCount(isFollowRedirects ? 2 : 0);
    }

    public HttpRequest setMaxRedirectCount(int maxRedirectCount) {
        this.maxRedirectCount = Math.max(maxRedirectCount, 0);
        return this;
    }

    public HttpRequest setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public HttpRequest setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public HttpRequest setSSLSocketFactory(SSLSocketFactory ssf) {
        this.ssf = ssf;
        return this;
    }

    public HttpRequest setSSLProtocol(String protocol) {
        Assert.notBlank(protocol, "protocol must be not blank!", new Object[0]);
        try {
            this.ssf = SSLSocketFactoryBuilder.create().setProtocol(protocol).build();
        }
        catch (Exception e) {
            throw new HttpException(e);
        }
        return this;
    }

    public HttpRequest setRest(boolean isRest) {
        this.isRest = isRest;
        return this;
    }

    public HttpRequest setChunkedStreamingMode(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public HttpResponse execute() {
        return this.execute(false);
    }

    public HttpResponse executeAsync() {
        return this.execute(true);
    }

    public HttpResponse execute(boolean isAsync) {
        this.urlWithParamIfGet();
        if (this.encodeUrlParams) {
            this.url = HttpUtil.encodeParams(this.url, this.charset);
        }
        this.initConnection();
        this.send();
        HttpResponse httpResponse = this.sendRedirectIfPossible();
        if (null == httpResponse) {
            httpResponse = new HttpResponse(this.httpConnection, this.charset, isAsync, this.isIgnoreResponseBody());
        }
        return httpResponse;
    }

    public HttpRequest basicAuth(String username, String password) {
        String data = username.concat(":").concat(password);
        String base64 = Base64.encode((CharSequence)data, this.charset);
        this.header("Authorization", "Basic " + base64, true);
        return this;
    }

    private void initConnection() {
        if (null != this.httpConnection) {
            this.httpConnection.disconnectQuietly();
        }
        this.httpConnection = HttpConnection.create(URLUtil.toUrlForHttp(this.url, this.urlHandler), this.proxy).setMethod(this.method).setHttpsInfo(this.hostnameVerifier, this.ssf).setConnectTimeout(this.connectionTimeout).setReadTimeout(this.readTimeout).setInstanceFollowRedirects(this.maxRedirectCount > 0).setChunkedStreamingMode(this.blockSize).header(this.headers, true);
        if (null != this.cookie) {
            this.httpConnection.setCookie(this.cookie);
        } else {
            GlobalCookieManager.add(this.httpConnection);
        }
        if (this.isDisableCache) {
            this.httpConnection.disableCache();
        }
    }

    private void urlWithParamIfGet() {
        if (Method.GET.equals((Object)this.method) && !this.isRest) {
            this.url = ArrayUtil.isNotEmpty(this.bodyBytes) ? HttpUtil.urlWithForm(this.url, StrUtil.str(this.bodyBytes, this.charset), this.charset, false) : HttpUtil.urlWithForm(this.url, this.form, this.charset, false);
        }
    }

    private HttpResponse sendRedirectIfPossible() {
        if (this.maxRedirectCount < 1) {
            return null;
        }
        if (this.httpConnection.getHttpURLConnection().getInstanceFollowRedirects()) {
            int responseCode;
            try {
                responseCode = this.httpConnection.responseCode();
            }
            catch (IOException e) {
                this.httpConnection.disconnectQuietly();
                throw new HttpException(e);
            }
            if (responseCode != 200 && (responseCode == 302 || responseCode == 301 || responseCode == 303)) {
                this.url = this.httpConnection.header(Header.LOCATION);
                if (this.redirectCount < this.maxRedirectCount) {
                    ++this.redirectCount;
                    return this.execute();
                }
            }
        }
        return null;
    }

    private void send() throws IORuntimeException {
        try {
            if (Method.POST.equals((Object)this.method) || Method.PUT.equals((Object)this.method) || Method.DELETE.equals((Object)this.method) || this.isRest) {
                if (CollectionUtil.isEmpty(this.fileForm)) {
                    this.sendFormUrlEncoded();
                } else {
                    this.sendMultipart();
                }
            } else {
                this.httpConnection.connect();
            }
        }
        catch (IOException e) {
            this.httpConnection.disconnectQuietly();
            throw new IORuntimeException(e);
        }
    }

    private void sendFormUrlEncoded() throws IOException {
        if (StrUtil.isBlank(this.header(Header.CONTENT_TYPE))) {
            this.httpConnection.header(Header.CONTENT_TYPE, ContentType.FORM_URLENCODED.toString(this.charset), true);
        }
        if (ArrayUtil.isNotEmpty(this.bodyBytes)) {
            IoUtil.write(this.httpConnection.getOutputStream(), true, this.bodyBytes);
        } else {
            String content = HttpUtil.toParams(this.form, this.charset);
            IoUtil.write(this.httpConnection.getOutputStream(), this.charset, true, content);
        }
    }

    private void sendMultipart() throws IOException {
        this.setMultipart();
        try (OutputStream out = this.httpConnection.getOutputStream();){
            this.writeFileForm(out);
            this.writeForm(out);
            this.formEnd(out);
        }
    }

    private void writeForm(OutputStream out) {
        if (CollectionUtil.isNotEmpty(this.form)) {
            StringBuilder builder = StrUtil.builder();
            for (Map.Entry<String, Object> entry : this.form.entrySet()) {
                builder.append("--").append(BOUNDARY).append("\r\n");
                builder.append(StrUtil.format((CharSequence)CONTENT_DISPOSITION_TEMPLATE, entry.getKey()));
                builder.append(entry.getValue()).append("\r\n");
            }
            IoUtil.write(out, this.charset, false, builder);
        }
    }

    private void writeFileForm(OutputStream out) {
        for (Map.Entry<String, Resource> entry : this.fileForm.entrySet()) {
            this.appendPart(entry.getKey(), entry.getValue(), out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendPart(String formFieldName, Resource resource, OutputStream out) {
        if (resource instanceof MultiResource) {
            for (Resource subResource : (MultiResource)resource) {
                this.appendPart(formFieldName, subResource, out);
            }
        } else {
            StringBuilder builder = StrUtil.builder().append("--").append(BOUNDARY).append("\r\n");
            String fileName = resource.getName();
            builder.append(StrUtil.format((CharSequence)CONTENT_DISPOSITION_FILE_TEMPLATE, formFieldName, ObjectUtil.defaultIfNull(fileName, formFieldName)));
            builder.append(StrUtil.format((CharSequence)CONTENT_TYPE_FILE_TEMPLATE, HttpUtil.getMimeType(fileName, "application/octet-stream")));
            IoUtil.write(out, this.charset, false, builder);
            InputStream in = null;
            try {
                in = resource.getStream();
                IoUtil.copy(in, out);
            }
            finally {
                IoUtil.close(in);
            }
            IoUtil.write(out, this.charset, false, "\r\n");
        }
    }

    private void formEnd(OutputStream out) throws IOException {
        out.write(BOUNDARY_END);
        out.flush();
    }

    private void setMultipart() {
        this.httpConnection.header(Header.CONTENT_TYPE, CONTENT_TYPE_MULTIPART_PREFIX + BOUNDARY, true);
    }

    private boolean isIgnoreResponseBody() {
        return Method.HEAD == this.method || Method.CONNECT == this.method || Method.OPTIONS == this.method || Method.TRACE == this.method;
    }
}

