/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.aop.interceptor;

import cn.hutool.json.JSONUtil;
import cn.lili.cache.Cache;
import cn.lili.common.aop.annotation.PreventDuplicateSubmissions;
import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.common.security.AuthUser;
import cn.lili.common.security.context.UserContext;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class PreventDuplicateSubmissionsInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PreventDuplicateSubmissionsInterceptor.class);
    @Autowired
    private Cache<String> cache;

    @Before(value="@annotation(preventDuplicateSubmissions)")
    public void interceptor(PreventDuplicateSubmissions preventDuplicateSubmissions) {
        try {
            String redisKey = this.getParams(preventDuplicateSubmissions.userIsolation());
            Long count = this.cache.incr(redisKey, preventDuplicateSubmissions.expire());
            log.debug("\u9632\u91cd\u590d\u63d0\u4ea4\uff1aparams-{},value-{}", (Object)redisKey, (Object)count);
            if (count.intValue() > 0) {
                throw new ServiceException(ResultCode.LIMIT_ERROR);
            }
        }
        catch (NullPointerException e) {
            return;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u9632\u91cd\u590d\u63d0\u4ea4\u62e6\u622a\u5668\u5f02\u5e38", (Throwable)e);
            throw new ServiceException(ResultCode.ERROR);
        }
    }

    private String getParams(Boolean userIsolation) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(request.getRequestURI());
        if (!request.getParameterMap().isEmpty()) {
            stringBuilder.append(JSONUtil.toJsonStr((Object)request.getParameterMap()));
        }
        if (userIsolation.booleanValue()) {
            AuthUser authUser = UserContext.getCurrentUser();
            if (authUser == null) {
                log.warn("user isolation settings are on,but current user is null");
            } else {
                stringBuilder.append(authUser.getId());
            }
        }
        return stringBuilder.toString();
    }
}

