/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.http.HttpUtil;
import cn.lili.common.utils.IpUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class IpHelper {
    private static final Logger log = LoggerFactory.getLogger(IpHelper.class);
    @Value(value="${lili.lbs.key}")
    private String key;
    @Value(value="${lili.lbs.sk}")
    private String sk;
    private static final String API = "https://apis.map.qq.com";

    public String getIpCity(HttpServletRequest request) {
        String url = "/ws/location/v1/ip?key=" + this.key + "&ip=" + IpUtils.getIpAddress(request);
        String sign = SecureUtil.md5((String)(url + this.sk));
        url = API + url + "&sign=" + sign;
        String result = "\u672a\u77e5";
        try {
            String json = HttpUtil.get((String)url, (int)3000);
            JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
            String status = jsonObject.get("status").getAsString();
            if ("0".equals(status)) {
                JsonObject address = jsonObject.get("result").getAsJsonObject().get("ad_info").getAsJsonObject();
                String nation = address.get("nation").getAsString();
                String province = address.get("province").getAsString();
                String city = address.get("city").getAsString();
                String district = address.get("district").getAsString();
                if (StrUtil.isNotBlank((CharSequence)nation) && StrUtil.isBlank((CharSequence)province)) {
                    result = nation;
                } else {
                    result = province;
                    if (StrUtil.isNotBlank((CharSequence)city)) {
                        result = result + " " + city;
                    }
                    if (StrUtil.isNotBlank((CharSequence)district)) {
                        result = result + " " + district;
                    }
                }
            }
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6IP\u5730\u7406\u4fe1\u606f\u5931\u8d25");
        }
        return result;
    }
}

