/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.redisExt;

import cn.lili.common.redisExt.JedisConnectionConfiguration;
import cn.lili.common.redisExt.RedisExtProperties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

public class JedisConnectionFactoryBean
implements FactoryBean<JedisConnectionFactory> {
    @Resource
    private RedisExtProperties redisExtProperties;
    private String extraRedisTemplateIdPrefix;
    private JedisConnectionFactory jedisConnectionFactory;

    public JedisConnectionFactoryBean(String extraRedisTemplateIdPrefix) {
        this.extraRedisTemplateIdPrefix = extraRedisTemplateIdPrefix;
    }

    private RedisExtProperties getRedisProperties() {
        return this.redisExtProperties.getExtra().get(this.extraRedisTemplateIdPrefix);
    }

    @PostConstruct
    public void init() {
        JedisConnectionConfiguration fc = new JedisConnectionConfiguration(this.getRedisProperties());
        JedisConnectionFactory factory = fc.redisConnectionFactory();
        factory.afterPropertiesSet();
        this.jedisConnectionFactory = factory;
    }

    public JedisConnectionFactory getObject() throws Exception {
        return this.jedisConnectionFactory;
    }

    public Class<?> getObjectType() {
        return JedisConnectionFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.jedisConnectionFactory != null) {
            this.jedisConnectionFactory.destroy();
        }
    }
}

