/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.redisExt;

import cn.lili.cache.config.redis.FastJsonRedisSerializer;
import cn.lili.common.redisExt.JedisConnectionFactoryBean;
import cn.lili.common.utils.SpringEnvironmentUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.util.Lists;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisExtTemplatePostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private static final String redisExtraIdPrefix = "duiba.redis.extra.";
    private static final String redisExtraIdSuffix = ".host";
    private BeanDefinitionRegistry beanDefinitionRegistry;
    private List<String> extRedisName = Lists.newArrayList();
    private static final String JEDIS_CONNECTION_FACTORY_BEAN_DESTROY_METHOD_NAME = "destroy";

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        this.beanDefinitionRegistry = beanDefinitionRegistry;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        String extraRedisTemplateIdPrefix;
        String redisConnectionFactoryBeanId;
        if (this.extRedisName == null || this.extRedisName.isEmpty()) {
            return;
        }
        Iterator<String> iterator = this.extRedisName.iterator();
        while (iterator.hasNext() && !this.beanDefinitionRegistry.containsBeanDefinition(redisConnectionFactoryBeanId = (extraRedisTemplateIdPrefix = iterator.next()) + "RedisConnectionFactory")) {
            AbstractBeanDefinition extraRedisConnectionFactoryDefinition = BeanDefinitionBuilder.genericBeanDefinition(JedisConnectionFactoryBean.class).setDestroyMethodName(JEDIS_CONNECTION_FACTORY_BEAN_DESTROY_METHOD_NAME).addConstructorArgValue((Object)extraRedisTemplateIdPrefix).getBeanDefinition();
            this.beanDefinitionRegistry.registerBeanDefinition(redisConnectionFactoryBeanId, (BeanDefinition)extraRedisConnectionFactoryDefinition);
            String extRedisTemplateBeanName = extraRedisTemplateIdPrefix + "RedisTemplate";
            AbstractBeanDefinition extraRedisTemplateDefinition = BeanDefinitionBuilder.genericBeanDefinition(RedisTemplate.class).addPropertyReference("connectionFactory", redisConnectionFactoryBeanId).addPropertyValue("defaultSerializer", new FastJsonRedisSerializer<Object>(Object.class)).getBeanDefinition();
            this.beanDefinitionRegistry.registerBeanDefinition(extRedisTemplateBeanName, (BeanDefinition)extraRedisTemplateDefinition);
            String extStringRedisTemplateBeanName = extraRedisTemplateIdPrefix + "StringRedisTemplate";
            AbstractBeanDefinition extraStringRedisTemplateDefinition = BeanDefinitionBuilder.genericBeanDefinition(StringRedisTemplate.class).addPropertyReference("connectionFactory", redisConnectionFactoryBeanId).getBeanDefinition();
            this.beanDefinitionRegistry.registerBeanDefinition(extStringRedisTemplateBeanName, (BeanDefinition)extraStringRedisTemplateDefinition);
        }
    }

    public void setEnvironment(Environment environment) {
        LinkedHashMap<String, Object> flatEnvironments = SpringEnvironmentUtils.getFlatEnvironments(environment);
        for (Map.Entry<String, Object> entry : flatEnvironments.entrySet()) {
            if (!entry.getKey().startsWith(redisExtraIdPrefix)) continue;
            int prefixLength = redisExtraIdPrefix.length();
            if (!entry.getKey().endsWith(redisExtraIdSuffix)) continue;
            this.extRedisName.add(entry.getKey().substring(prefixLength, entry.getKey().length() - redisExtraIdSuffix.length()));
        }
    }
}

