/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.threadpool.factory;

import cn.lili.common.threadpool.properties.ThreadPoolConfig;
import cn.lili.common.threadpool.properties.ThreadPoolProperties;
import cn.lili.common.threadpool.wrapper.ThreadPoolExecutorWrapper;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ThreadPoolFactoryBean
implements FactoryBean<ThreadPoolExecutorWrapper> {
    @Autowired
    private ThreadPoolConfig duibaThreadPoolConfig;
    private String threadPoolName;

    public ThreadPoolExecutorWrapper getObject() {
        Objects.requireNonNull(this.threadPoolName);
        Map<String, ThreadPoolProperties> extra = this.duibaThreadPoolConfig.getExtra();
        ThreadPoolProperties properties = StringUtils.equals((CharSequence)this.threadPoolName, (CharSequence)"executorService") ? this.duibaThreadPoolConfig.getDefaultThreadPoolProperties() : extra.get(this.threadPoolName);
        if (properties == null) {
            throw new IllegalArgumentException("\u7f3a\u5931\u7ebf\u7a0b\u6c60" + this.threadPoolName + "\u7684\u914d\u7f6e");
        }
        ThreadPoolExecutorWrapper wrapper = new ThreadPoolExecutorWrapper(this.threadPoolName, properties);
        wrapper.afterPropertiesSet();
        return wrapper;
    }

    public Class<?> getObjectType() {
        return ThreadPoolExecutorWrapper.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }
}

