/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.utils;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolUtil {
    private static final int SIZE_CORE_POOL = 5;
    private static final int SIZE_MAX_POOL = 10;
    private static final long ALIVE_TIME = 2000L;
    private static final BlockingQueue<Runnable> BQUEUE = new ArrayBlockingQueue<Runnable>(100);
    private static final ThreadPoolExecutor POOL = new ThreadPoolExecutor(5, 10, 2000L, TimeUnit.MILLISECONDS, BQUEUE, new ThreadPoolExecutor.CallerRunsPolicy());
    public static volatile ThreadPoolExecutor threadPool;

    public static void execute(Runnable runnable) {
        ThreadPoolUtil.getThreadPool().execute(runnable);
    }

    public static <T> Future<T> submit(Callable<T> callable) {
        return ThreadPoolUtil.getThreadPool().submit(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolExecutor getThreadPool() {
        if (threadPool != null) {
            return threadPool;
        }
        Class<ThreadPoolUtil> clazz = ThreadPoolUtil.class;
        synchronized (ThreadPoolUtil.class) {
            if (threadPool == null) {
                threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return threadPool;
        }
    }

    public static ThreadPoolExecutor getPool() {
        return POOL;
    }

    public static void main(String[] args) {
        System.out.println(POOL.getPoolSize());
    }

    static {
        POOL.prestartAllCoreThreads();
    }
}

