/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.cache.impl;

import cn.lili.cache.Cache;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={RedisOperations.class})
public class RedisCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(RedisCache.class);
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;

    public Object get(Object key) {
        return this.redisTemplate.opsForValue().get(key);
    }

    @Override
    public String getString(Object key) {
        try {
            return this.redisTemplate.opsForValue().get(key).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List multiGet(Collection keys) {
        return this.redisTemplate.opsForValue().multiGet(keys);
    }

    @Override
    public void multiSet(Map map) {
        this.redisTemplate.opsForValue().multiSet(map);
    }

    @Override
    public void multiDel(Collection keys) {
        this.redisTemplate.delete(keys);
    }

    public void put(Object key, Object value) {
        this.redisTemplate.opsForValue().set(key, value);
    }

    public void put(Object key, Object value, Long exp) {
        this.put(key, value, exp, TimeUnit.SECONDS);
    }

    public void put(Object key, Object value, Long exp, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set(key, value, exp.longValue(), timeUnit);
    }

    @Override
    public Boolean remove(Object key) {
        return this.redisTemplate.delete(key);
    }

    @Override
    public void vagueDel(Object key) {
        List<Object> keys = this.keys(key + "*");
        this.redisTemplate.delete(keys);
    }

    @Override
    public void clear() {
        List<Object> keys = this.keys("*");
        this.redisTemplate.delete(keys);
    }

    @Override
    public void putHash(Object key, Object hashKey, Object hashValue) {
        this.redisTemplate.opsForHash().put(key, hashKey, hashValue);
    }

    @Override
    public void putAllHash(Object key, Map map) {
        this.redisTemplate.opsForHash().putAll(key, map);
    }

    public Object getHash(Object key, Object hashKey) {
        return this.redisTemplate.opsForHash().get(key, hashKey);
    }

    @Override
    public Map<Object, Object> getHash(Object key) {
        return this.redisTemplate.opsForHash().entries(key);
    }

    @Override
    public boolean hasKey(Object key) {
        return this.redisTemplate.opsForValue().get(key) != null;
    }

    @Override
    public List<Object> keys(String pattern) {
        ArrayList<Object> keys = new ArrayList<Object>();
        this.scan(pattern, item -> {
            String key = new String((byte[])item, StandardCharsets.UTF_8);
            keys.add(key);
        });
        return keys;
    }

    @Override
    public List<Object> keysBlock(String pattern) {
        Set set = this.redisTemplate.keys((Object)pattern);
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(set);
        return list;
    }

    private void scan(String pattern, Consumer<byte[]> consumer) {
        this.redisTemplate.execute(connection -> {
            try (Cursor cursor = connection.scan(ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build());){
                cursor.forEachRemaining(consumer);
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public Long cumulative(Object key, Object value) {
        HyperLogLogOperations operations = this.redisTemplate.opsForHyperLogLog();
        return operations.add(key, new Object[]{value});
    }

    @Override
    public Long counter(Object key) {
        HyperLogLogOperations operations = this.redisTemplate.opsForHyperLogLog();
        return operations.size(new Object[]{key});
    }

    @Override
    public List multiCounter(Collection keys) {
        if (keys == null) {
            return new ArrayList();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (Object key : keys) {
            result.add(this.counter(key));
        }
        return result;
    }

    @Override
    public Long mergeCounter(Object ... key) {
        HyperLogLogOperations operations = this.redisTemplate.opsForHyperLogLog();
        return operations.union(key[0], key);
    }

    @Override
    public Long incr(String key, long liveTime) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        Long increment = entityIdCounter.getAndIncrement();
        if (increment == 0L && liveTime > 0L) {
            entityIdCounter.expire(liveTime, TimeUnit.SECONDS);
        }
        return increment;
    }

    @Override
    public Long incr(String key) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        return entityIdCounter.getAndIncrement();
    }

    @Override
    public void incrementScore(String sortedSetName, String keyword) {
        this.redisTemplate.opsForZSet().incrementScore((Object)sortedSetName, (Object)keyword, 1.0);
    }

    @Override
    public void incrementScore(String sortedSetName, String keyword, Integer score) {
        this.redisTemplate.opsForZSet().incrementScore((Object)sortedSetName, (Object)keyword, (double)score.intValue());
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> reverseRangeWithScores(String sortedSetName, Integer start, Integer end) {
        return this.redisTemplate.opsForZSet().reverseRangeWithScores((Object)sortedSetName, (long)start.intValue(), (long)end.intValue());
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> reverseRangeWithScores(String sortedSetName, Integer count) {
        return this.redisTemplate.opsForZSet().reverseRangeWithScores((Object)sortedSetName, 0L, (long)count.intValue());
    }

    @Override
    public boolean zAdd(String key, long score, String value) {
        return this.redisTemplate.opsForZSet().add((Object)key, (Object)value, (double)score);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> zRangeByScore(String key, int from, long to) {
        return this.redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, (double)from, (double)to);
    }

    @Override
    public Long zRemove(String key, String ... value) {
        return this.redisTemplate.opsForZSet().remove((Object)key, (Object[])value);
    }
}

