/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.redisExt;

import cn.lili.common.redisExt.RedisExtProperties;
import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisPoolConfig;

public class JedisConnectionConfiguration {
    private final RedisExtProperties properties;

    JedisConnectionConfiguration(RedisExtProperties properties) {
        this.properties = properties;
    }

    public JedisConnectionFactory redisConnectionFactory() {
        return this.createJedisConnectionFactory();
    }

    private JedisConnectionFactory createJedisConnectionFactory() {
        JedisClientConfiguration clientConfiguration = this.getJedisClientConfiguration();
        return new JedisConnectionFactory(this.getStandaloneConfig(), clientConfiguration);
    }

    protected final RedisStandaloneConfiguration getStandaloneConfig() {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(this.properties.getHost());
        config.setPort(this.properties.getPort());
        config.setPassword(RedisPassword.of((String)this.properties.getPassword()));
        config.setDatabase(this.properties.getDatabase());
        return config;
    }

    private JedisClientConfiguration getJedisClientConfiguration() {
        JedisClientConfiguration.JedisClientConfigurationBuilder builder = this.applyProperties(JedisClientConfiguration.builder());
        RedisExtProperties.Pool pool = this.properties.getPool();
        if (pool != null) {
            this.applyPooling(pool, builder);
        }
        return builder.build();
    }

    private void applyPooling(RedisExtProperties.Pool pool, JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        builder.usePooling().poolConfig((GenericObjectPoolConfig)this.jedisPoolConfig(pool));
    }

    private JedisPoolConfig jedisPoolConfig(RedisExtProperties.Pool pool) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(pool.getMaxActive());
        config.setMaxIdle(pool.getMaxIdle());
        config.setMinIdle(pool.getMinIdle());
        if (pool.getMaxWait() != null) {
            config.setMaxWait(Duration.ofMillis(pool.getMaxWait().toMillis()));
        }
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRunsMillis(90000L);
        config.setSoftMinEvictableIdleTimeMillis(180000L);
        config.setMinEvictableIdleTimeMillis(-1L);
        config.setNumTestsPerEvictionRun(-1);
        return config;
    }

    private JedisClientConfiguration.JedisClientConfigurationBuilder applyProperties(JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        if (this.properties.isSsl()) {
            builder.useSsl();
        }
        if (this.properties.getTimeout() != null) {
            Duration timeout = this.properties.getTimeout();
            builder.readTimeout(timeout).connectTimeout(timeout);
        }
        return builder;
    }
}

