/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.security.sensitive;

import cn.lili.common.properties.SystemSettingProperties;
import cn.lili.common.security.AuthUser;
import cn.lili.common.security.context.UserContext;
import cn.lili.common.security.enums.UserEnums;
import cn.lili.common.security.sensitive.Sensitive;
import cn.lili.common.security.sensitive.enums.SensitiveStrategy;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SensitiveJsonSerializer
extends JsonSerializer<String>
implements ContextualSerializer,
ApplicationContextAware {
    private SensitiveStrategy strategy;
    private SystemSettingProperties systemSettingProperties;

    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeString(this.strategy.desensitizer().apply(value));
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Sensitive annotation;
        if (this.desensitization() && Objects.nonNull(annotation = (Sensitive)property.getAnnotation(Sensitive.class)) && Objects.equals(String.class, property.getType().getRawClass())) {
            this.strategy = annotation.strategy();
            return this;
        }
        return prov.findValueSerializer(property.getType(), property);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.systemSettingProperties = (SystemSettingProperties)applicationContext.getBean(SystemSettingProperties.class);
    }

    private boolean desensitization() {
        AuthUser authUser = UserContext.getCurrentUser();
        if (authUser == null) {
            return false;
        }
        if (authUser.getRole() != null && authUser.getRole().equals((Object)UserEnums.STORE)) {
            return this.systemSettingProperties.getSensitiveLevel() == 2;
        }
        if (authUser.getRole() != null && authUser.getRole().equals((Object)UserEnums.MANAGER)) {
            return this.systemSettingProperties.getSensitiveLevel() >= 1;
        }
        return false;
    }
}

