/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.cache.limit.interceptor;

import cn.lili.cache.limit.annotation.LimitPoint;
import cn.lili.cache.limit.enums.LimitTypeEnums;
import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.common.utils.IpUtils;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Configuration
@ConditionalOnClass(value={RedisOperations.class})
public class LimitInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LimitInterceptor.class);
    private RedisTemplate<String, Serializable> redisTemplate;
    private DefaultRedisScript<Long> limitScript;

    @Autowired
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Autowired
    public void setLimitScript(DefaultRedisScript<Long> limitScript) {
        this.limitScript = limitScript;
    }

    @Before(value="@annotation(limitPointAnnotation)")
    public void interceptor(LimitPoint limitPointAnnotation) {
        LimitTypeEnums limitTypeEnums = limitPointAnnotation.limitType();
        int limitPeriod = limitPointAnnotation.period();
        int limitCount = limitPointAnnotation.limit();
        String key = limitTypeEnums == LimitTypeEnums.CUSTOMER ? limitPointAnnotation.key() : limitPointAnnotation.key() + IpUtils.getIpAddress(((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest());
        ImmutableList keys = ImmutableList.of((Object)StringUtils.join((Object[])new String[]{limitPointAnnotation.prefix(), key}));
        try {
            Number count = (Number)this.redisTemplate.execute(this.limitScript, (List)keys, new Object[]{limitCount, limitPeriod});
            assert (count != null);
            log.info("\u9650\u5236\u8bf7\u6c42{}, \u5f53\u524d\u8bf7\u6c42{},\u7f13\u5b58key{}", new Object[]{limitCount, count.intValue(), key});
            if (count.intValue() > limitCount) {
                throw new ServiceException(ResultCode.LIMIT_ERROR);
            }
        }
        catch (NullPointerException e) {
            return;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u9650\u6d41\u5f02\u5e38", (Throwable)e);
            throw new ServiceException(ResultCode.ERROR);
        }
    }
}

