/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.cache.util;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={RedisOperations.class})
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Autowired
    private RedisTemplate redisTemplate;

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u6307\u5b9a\u7f13\u5b58\u5931\u6548\u65f6\u95f4\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public <T> T get(String key, Class<T> clazz) {
        Object o = key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
        return (T)o;
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u653e\u5165\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u666e\u901a\u7f13\u5b58\u653e\u5165\u5e76\u8bbe\u7f6e\u65f6\u95f4\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            log.error("\u5c06\u6570\u636e\u653e\u5165set\u7f13\u5b58\u9519\u8bef", (Throwable)e);
            return 0L;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("\u5c06list\u653e\u5165\u7f13\u5b58\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u5c06list\u653e\u5165\u7f13\u5b58\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("\u5c06list\u653e\u5165\u7f13\u5b58\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u5c06list\u653e\u5165\u7f13\u5b58\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    public boolean zadd(String key, long score, String value) {
        return this.redisTemplate.opsForZSet().add((Object)key, (Object)value, (double)score);
    }

    public Set<DefaultTypedTuple> zrangeByScoreWithScores(String key, int from, long to) {
        Set set = this.redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, (double)from, (double)to);
        return set;
    }

    public Long zremove(String key, String ... value) {
        return this.redisTemplate.opsForZSet().remove((Object)key, (Object[])value);
    }
}

