/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.aop.interceptor;

import cn.lili.common.aop.annotation.RetryOperation;
import cn.lili.common.exception.RetryException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RetryAspect {
    private static final Logger log = LoggerFactory.getLogger(RetryAspect.class);

    @Around(value="@annotation(retryOperation)")
    public Object retryOperation(ProceedingJoinPoint joinPoint, RetryOperation retryOperation) throws Throwable {
        Object response = null;
        int retryCount = retryOperation.retryCount();
        int waitSeconds = retryOperation.waitSeconds();
        boolean successful = false;
        do {
            try {
                response = joinPoint.proceed();
                successful = true;
            }
            catch (RetryException ex) {
                log.info("Operation failed, retries remaining: {}", (Object)retryCount);
                if (--retryCount < 0) {
                    successful = true;
                    log.error(ex.getMessage());
                }
                if (waitSeconds <= 0 || successful) continue;
                log.info("Waiting for {} second(s) before next retry", (Object)waitSeconds);
                Thread.sleep((long)waitSeconds * 1000L);
            }
        } while (!successful);
        return response;
    }
}

