/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.security;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.common.security.AuthUser;
import cn.lili.common.security.context.UserContext;
import cn.lili.common.utils.BeanUtil;
import java.util.Objects;

public class OperationalJudgment {
    public static <T> T judgment(T object) {
        return OperationalJudgment.judgment(object, "memberId", "storeId");
    }

    public static <T> T judgment(T object, String buyerIdField, String storeIdField) {
        AuthUser tokenUser = Objects.requireNonNull(UserContext.getCurrentUser());
        switch (tokenUser.getRole()) {
            case MANAGER: {
                return object;
            }
            case MEMBER: {
                if (tokenUser.getId().equals(BeanUtil.getFieldValueByName(buyerIdField, object))) {
                    return object;
                }
                throw new ServiceException(ResultCode.USER_AUTHORITY_ERROR);
            }
            case STORE: {
                if (tokenUser.getStoreId().equals(BeanUtil.getFieldValueByName(storeIdField, object))) {
                    return object;
                }
                throw new ServiceException(ResultCode.USER_AUTHORITY_ERROR);
            }
        }
        throw new ServiceException(ResultCode.USER_AUTHORITY_ERROR);
    }
}

