/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.security.context;

import cn.hutool.core.text.CharSequenceUtil;
import cn.lili.cache.Cache;
import cn.lili.cache.CachePrefix;
import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.common.security.AuthUser;
import cn.lili.common.security.enums.SecurityEnum;
import cn.lili.common.security.token.SecretKeyUtil;
import com.google.gson.Gson;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class UserContext {
    public static AuthUser getCurrentUser() {
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String accessToken = request.getHeader(SecurityEnum.HEADER_TOKEN.getValue());
            return UserContext.getAuthUser(accessToken);
        }
        return null;
    }

    public static String getUuid() {
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            return request.getHeader(SecurityEnum.UUID.getValue());
        }
        return null;
    }

    public static AuthUser getAuthUser(Cache cache, String accessToken) {
        try {
            AuthUser authUser = UserContext.getAuthUser(accessToken);
            assert (authUser != null);
            if (!cache.hasKey(CachePrefix.ACCESS_TOKEN.getPrefix(authUser.getRole()) + accessToken)) {
                throw new ServiceException(ResultCode.USER_AUTHORITY_ERROR);
            }
            return authUser;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCurrentUserToken() {
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            return request.getHeader(SecurityEnum.HEADER_TOKEN.getValue());
        }
        return null;
    }

    public static AuthUser getAuthUser(String accessToken) {
        try {
            Claims claims = (Claims)Jwts.parserBuilder().setSigningKey((Key)SecretKeyUtil.generalKeyByDecoders()).build().parseClaimsJws(accessToken).getBody();
            String json = claims.get((Object)SecurityEnum.USER_CONTEXT.getValue()).toString();
            return (AuthUser)new Gson().fromJson(json, AuthUser.class);
        }
        catch (ExpiredJwtException eje) {
            throw new ServiceException(ResultCode.USER_AUTH_EXPIRED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void settingInviter(String memberId, Cache cache) {
        HttpServletRequest request;
        String inviterId;
        if (RequestContextHolder.getRequestAttributes() != null && CharSequenceUtil.isNotEmpty((CharSequence)(inviterId = (request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest()).getHeader(SecurityEnum.INVITER.getValue())))) {
            cache.put(CachePrefix.INVITER.getPrefix() + memberId, inviterId);
        }
    }
}

