/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.threadpool;

import cn.lili.common.threadpool.factory.ThreadPoolFactoryBean;
import cn.lili.common.threadpool.properties.ThreadPoolConfig;
import cn.lili.common.threadpool.properties.ThreadPoolProperties;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ThreadPoolBeanFactoryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private Logger logger = LoggerFactory.getLogger(ThreadPoolBeanFactoryPostProcessor.class);
    private static final String THREAD_POOL_PREFIX = "duiba.threadpool";
    private BeanDefinitionRegistry beanDefinitionRegistry;
    private Set<String> threadPoolNames = Sets.newHashSet();

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        this.beanDefinitionRegistry = beanDefinitionRegistry;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        if (this.threadPoolNames.isEmpty()) {
            return;
        }
        for (String threadPoolName : this.threadPoolNames) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ThreadPoolFactoryBean.class);
            builder.addPropertyValue("threadPoolName", (Object)threadPoolName);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            Boolean isPrimary = StringUtils.equals((CharSequence)threadPoolName, (CharSequence)"executorService");
            beanDefinition.setPrimary(isPrimary.booleanValue());
            String beanName = threadPoolName;
            if (!beanName.endsWith("ExecutorService") && !isPrimary.booleanValue()) {
                beanName = beanName + "ExecutorService";
            }
            this.beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    public void setEnvironment(Environment environment) {
        ThreadPoolConfig config = (ThreadPoolConfig)Binder.get((Environment)environment).bindOrCreate(THREAD_POOL_PREFIX, ThreadPoolConfig.class);
        if (!config.getEnabled().booleanValue()) {
            return;
        }
        this.threadPoolNames.add("executorService");
        Map<String, ThreadPoolProperties> extra = config.getExtra();
        this.threadPoolNames.addAll(extra.keySet());
        if (config.getMaxSizeCount() >= ThreadPoolConfig.THREAD_MAX_SIZE) {
            this.logger.warn("\u7ebf\u7a0b\u603b\u914d\u7f6e\u6570\u8fc7\u9ad8", (Object)"\u9601\u4e0b\u7684\u7cfb\u7edf\u7ebf\u7a0b\u6c60\u4e2d\u7684\u7ebf\u7a0b\u603b\u6570\u914d\u7f6e\u8fc7\u9ad8\uff0c\u53ef\u80fd\u5bfc\u81f4CPU\u7ebf\u7a0b\u4e0a\u4e0b\u6587\u5207\u6362\u9891\u7e41\uff0c\u5f71\u54cd\u6027\u80fd\uff0c\u5efa\u8bae\u964d\u4f4e\u914d\u7f6e\u603b\u6570\uff0c\u6216\u8005\u8fdb\u884c\u7cfb\u7edf\u62c6\u5206\uff0c\u4ee5\u964d\u4f4e\u7ebf\u7a0b\u6c60\u6570\u76ee");
        }
    }
}

