/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.utils;

import cn.hutool.core.text.CharSequenceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularUtil {
    private static final Pattern MOBILE = Pattern.compile("^1[3|4|5|8][0-9]\\d{8}$");
    private static final Pattern EMAIL = Pattern.compile("^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*\\.[a-zA-Z0-9]{2,6}$");
    static Pattern sqlPattern = Pattern.compile("(select|update|and|delete|insert|trancate|char|substr|ascii|declare|exec|count|master|into|drop|execute)", 2);
    static Pattern symbolPattern = Pattern.compile("[\\s~\u00b7`!\uff01@#\uffe5$%^\u2026\u2026&*\uff08()\uff09\\-\u2014\u2014\\-_=+\u3010\\[\\]\u3011\uff5b{}\uff5d\\|\u3001\\\\\uff1b;\uff1a:\u2018'\u201c\u201d\"\uff0c,\u300a<\u3002.\u300b>\u3001/\uff1f?]");

    public static boolean mobile(String v) {
        Matcher m = MOBILE.matcher(v);
        return m.matches();
    }

    public static boolean email(String v) {
        Matcher m = EMAIL.matcher(v);
        return m.matches();
    }

    public static String replace(String str) {
        return RegularUtil.symbolReplace(RegularUtil.sqlReplace(str));
    }

    public static String sqlReplace(String str) {
        if (CharSequenceUtil.isEmpty((CharSequence)str)) {
            return "";
        }
        Matcher sqlMatcher = sqlPattern.matcher(str);
        return sqlMatcher.replaceAll("");
    }

    public static String symbolReplace(String str) {
        if (CharSequenceUtil.isEmpty((CharSequence)str)) {
            return "";
        }
        Matcher symbolMatcher = symbolPattern.matcher(str);
        return symbolMatcher.replaceAll("");
    }

    public static void main(String[] args) {
        System.out.println(RegularUtil.replace("selectSELECTINORNOTIN123\u963f\u677e\u5927asdfa!@#$%^&&*()_+{}[]\uff01\uff1f>?").trim());
    }
}

